#!/usr/local/bin/perl
#
# $Header: getHostHardwareType.pl 24-sep-2004.09:37:26 sacgoyal Exp $
#
# getHostHardwareType.pl
#
# Copyright (c) 2004, Oracle. All rights reserved.  
#
#    NAME
#      getHostHardwareType.pl - <one-line expansion of the name>
#
#    DESCRIPTION
#      <short description of component this file declares/defines>
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    sacgoyal    09/24/04 - sacgoyal_gethosthardwaretype_file
#    sacgoyal    09/13/04 - Creation for Dell Hw extension of Host Mgmt, Enterprise Manager, 10.2


use strict;
use File::Basename;

my $snmpd_state = 0;
my $omreport_state = 0;

#
# Checking if a process, whose basename is snmpd, is up and running.
#
my @psList = ();                # list of processes
@psList = `ps -eo "s args"`;
if ($? != 0)
{
  raise_error_and_exit("Failed to run ps command", 1);
}
shift @psList;       # remove ps header line
foreach my $psLine( @psList )
{
    $psLine =~ s/^\s+//;   # remove any leading space
    chomp($psLine);
    my ($state, @cmdArgs) = split(/\s+/,$psLine);
    my $command = basename($cmdArgs[0], "");

    if( $command eq "snmpd" and $state eq "S")
    {
      $snmpd_state = 1;
      last;
    }
}
 
#
# Checking for the existence of executable /usr/bin/omreport on the host
#
if (-e "/usr/bin/omreport")
{
  $omreport_state = 1;
}


if( $snmpd_state == 1 and  $omreport_state == 1)
{
  print "em_result=Dell_PowerEdge\n";
}
else
{
  print "em_result=Generic\n";
}
 
sub raise_error_and_exit()
{
  my ($message, $exit_status) = @_;
  EMD_PERL_ERROR($message);
  print STDERR "$message \n";
  exit $exit_status;
}

