# $Header: hostAssoc.pl 03-aug-2005.08:54:56 ndutko Exp $
#
# Package : hostAssoc.pl
#
# Copyright (c) 2005, Oracle. All rights reserved.  
#
#   NAME
#       hostAssoc.pl
#
#   DESCRIPTION
#       Returns targets associated with this host
#
#   List of standard assocation types are in
#   ecmAssoc.pm
#
#   returns potentially multiple 
# em_result=association_type|target_name|target_type|target_properties
#
#
# association_type: one of the types listed in ecmAssoc.pm
# target_name: the target_name of the associated target
# target_type: the target_type of the associated target
# target_properties: related information that may help determine true target name given the target_type
#
#   NOTES
#
#   MODIFIED     (MM/DD/YY)
#      ndutko     08/03/05 - ndutko_code_checkin
#      glavash    04/05/05 - split out from Ptdpm9.pm 
##*************************************************************

use strict;

use hostOSD;


#
# relationship types are defined in ecmassoc.pm
#
use ecmAssoc;

#******************************************
#     Global Variables
#*****************************************
      my $result = ();
#
# as new relationships are exposed, add them here
# we start off with name server relationships
#

#   get dns name server results from existing routine
#   requesting assocation format
#   The DNS Nameserver information is actually logged as part of another
#   configuration metric.  By passing in the type of result we are expecting
#   the function can return the coorect record format.

    my @dns_name_server_results = getDNSNameServersResults($hostOSD::ASSOCIATION_RESULT);

    # if we are sorting results sort then print
    if ($hostOSD::SORT_RESULTS == 1)
    {
      my @results = ();
      my $i = 0;

      # if new relationships are added, add the array processing in both
      # places, sorted and unsorted
      foreach $result (@dns_name_server_results)
      {
        $results[$i++] = $result;
      }
      foreach $result (sort(@results))
      {
        print $result;
      }
    }
    # else print them array by array
    else
    {
      foreach $result (@dns_name_server_results)
      {
        print $result;
      }
    }
1;
# End of the Program
