#!/usr/local/bin/perl
# 
# $Header: emll/sysman/admin/scripts/hostServices.pl /main/3 2010/08/25 21:01:17 aghanti Exp $
#
# hostServices.pl
# 
# Copyright (c) 2006, 2010, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      hostServices.pl
#
#    DESCRIPTION
#      List all user-visible servces and current state
#
#    NOTES
#
#    MODIFIED   (MM/DD/YY)
#    aghanti     08/24/10 - Bug 9399609 - Fix service names to be in UTF-8
#    ckalivar    06/11/10 - Fix Bug:9799232- each row will now contain 4
#                           columns as expected in OS_INIT_SERVICES
#    jsutton     06/26/06 - Creation
# 
use strict;
use Win32::Service;
use Encode;

my %services = ();
my %svcStatus = ();
my ($ret,$service, $svcState);
my $codeKey = '';
my $codePage = '';
my $enc;

# Set all output to be in UTF-8
binmode (STDOUT,":encoding(UTF-8)");
binmode (STDERR,":encoding(UTF-8)");

# Try to determine the current Code Page (encoding) on the system
my $CODEPAGE_REGISTRY_KEY = 'HKEY_LOCAL_MACHINE/SYSTEM/CurrentControlSet/Control/Nls/CodePage';
eval {
  use Win32::TieRegistry ();
  $codeKey = Win32::TieRegistry->new($CODEPAGE_REGISTRY_KEY,
                                    { Delimiter => "/" });
};
# Get the Active CodePage (or OEM Code Page if ACP is not set)
if (ref $codeKey)
{
  $codePage = $codeKey->GetValue("ACP") || $codeKey->GetValue("OEMCP");
}
if ($codePage ne '' && $codePage =~ m/^[0-9a-fA-F]+$/s)
{
  # Code pages are of the format cp<number>
  $codePage = "cp".lc($codePage);
  # See if this encoding is available in the perl we ship
  $enc = find_encoding($codePage);
}

# Get hash of all services
Win32::Service::GetServices('', \%services);

foreach $service (keys %services) 
{
  # Get this service's status information
  $ret = Win32::Service::GetStatus('',$services{$service},\%svcStatus);

  # Decode service name to UTF-8 only if the source encoding is available
  if (ref $enc)
  {
    $service = $enc->decode($service);
  }

  if ($ret != 0)
  {
    # CurrentState can be a value from 1-7.  Only 4 is running, the remainder are some
    # other (stopped, stop pending, start pending, paused, pause pending, continue pending).
    # The last two columns are application_id and mapper version, which can not be null,
    # and they are numberic fields, so use -1 instead.
    print "em_result=$service|" . (($svcStatus{CurrentState} == 4) ? "on" : "off") . "|-1|-1\n";
  }
  # clear the status hash for the next pass
  %svcStatus = ();
} 
