# $Header: hostbufferactivity.pl 15-mar-2005.13:14:59 qding Exp $
# 
# hostbufferactivity.pl
# 
# Copyright (c) 2001, 2005, Oracle. All rights reserved.  
#
#    NAME
#      hostbufferactivity.pl 
#
#    DESCRIPTION
#       returns system buffer activity as:
#       em_result=<physical reads from block devices to buffer cache>|
#                 <physical writes from block devices to buffer cache>|
#                 <reads from buffer cache per sec>|
#                 <writes to buffer cache per sec>|
#                 <buffer cache read hit ratio>|
#                 <buffer cache write hit ratio>|
#                 <reads per sec from character devices using physio>|
#                 <writes per sec from character devices using physio>
#
#    NOTES
#        data collected and averaged over a 5 second interval
#
#    MODIFIED   (MM/DD/YY)
#    qding       03/14/05 - set locale to C 
#    vsekuboy    04/29/03 - Removed all unknown values on Linux
#    xxu         06/25/02 - remove /usr/local/bin/perl
#    aaitghez    05/18/01 - sar comman host buffer activity.
#    aaitghez    05/18/01 - Creation
# 

$ENV{LC_ALL} = "C";
$ENV{PATH} = "/bin:/usr/bin:/usr/sbin:/usr/local/bin:/local/bin";

chomp ($os = `uname -s`);

if ( $os eq "SunOS" || $os eq "HP-UX" ) {
# invoke sar
$r = `sar -b 5`
    or die "failed to execute sar";

#parse the return string into lines
@res = split(m/pwrit\/s\n/, $r);
@values = split(m/[\t\s]+/, @res[1]);

print "em_result=@values[1]|@values[2]|@values[3]|@values[4]|@values[5]|@values[6]|@values[7]|@values[8]\n";

}
else {
# sar
# -b    Report  I/O  and transfer rate statistics. The fol
#       lowing values are displayed:
#
#       tps
#              Total number of transfers  per  second  that
#              were  issued to the physical disk.  A trans
#              fer is an I/O request to the physical  disk.
#              Multiple  logical  requests  can be combined
#              into a single I/O request to  the  disk.   A
#              transfer is of indeterminate size.
#
#       rtps
#              Total  number  of  read  requests per second
#              issued to the physical disk.
#
#       wtps
#              Total number of write  requests  per  second
#              issued to the physical disk.
#
#       bread/s
#              Total  amount of data read from the drive in
#              blocks per second.  A block is of indetermi
#              nate size.
#
#       bwrtn/s
#              Total amount of data written to the drive in
#              blocks per second.


  @value = `sar -b 1 5` or die "Failed to execute sar -b\n";
  @data = split(/[\s\t\n]+/, $value[$#value]);
  print "em_result=$data[2]|$data[3]|0|0|0|0|$data[4]|$data[5]\n";

  exit 0;
}

