# $Header: emll/sysman/admin/scripts/hosthw.pl /osds/3 2010/02/28 18:15:56 ndutko Exp $
#
# Package : hosthw.pl
#
# Copyright (c) 2002, 2010, Oracle and/or its affiliates. All rights reserved. 
#
#   NAME
#       hosthw.pl
#
#   DESCRIPTION
#       Collects hardware data
#
#   returns EM_RESULT = 
# with values for
#| 'HOSTNAME';
#| 'DOMAIN';
#|  VENDOR
#| 'SYSTEM_CONFIG';
#| 'MACHINE_ARCHITECTURE';
#| 'CLOCK_FREQ_IN_MHZ';
#| 'MEMORY_SIZE_IN_MB';
#| 'LOCAL_DISK_SPACE_IN_GB';
#| 'CPU_COUNT';
#| 'CPU_BOARD_COUNT';
#| 'IOCARD_COUNT';
#| 'FAN_COUNT';
#| 'POWER_SUPPLY_COUNT';
#| 'BOOT_DISK_VOLUME_SERIAL_NUM';
#| 'SYSTEM_BIOS';
#| 'SYSTEM_SERIAL_NUMBER';
#| 'AVAIL_LOCAL_DISK_SPACE_IN_GB';
#| 'AVAIL_MEMORY_SIZE_IN_MB';
#| 'HOST_ID';
#
#
#   NOTES
#
#   MODIFIED     (MM/DD/YY)
#      ndutko     08/03/05 - ndutko_code_checkin
#      glavash    04/04/05 - split out from Ptdpm1.pm 
##*************************************************************

use strict;

use hostOSD;
use hostServiceTags;
use POSIX;

#use Carp;
#require 5.005;

#require 5.6.1;
#require Exporter;

#use ecmErrorMsgs;

#******************************************
#     Global Variables
#******************************************

use constant NOT_FOUND      => -1;
use constant COLON_CHR      => ':';
use constant DOT_CHR        => '.';
use constant NIL            => '';

    my $NoOfBrd   = 0;
    my $NoOfCPU   = 0;
    my $NoOfCards = 0;

    #DO NOT supply values for avail disk or avail memory
 
     my $NoOfFan   = NIL;
     my $NoOfPower = NIL;
     my $avail_mem = NIL;
     my $avail_disk = NIL;
     my $boot_disk = NIL;
     my $system_bios = NIL;
     my $system_serial = NIL; 
    my $boot_disk = NIL;
    my $memory       = NIL;
    my $clock        = NIL;
    my $hw_name      = NIL;
    my $host_id      = NIL;
    my $domain = NIL;
    my $j      = 0;

    my $hostname = getHostName();

    $domain = getDomainName($hostname);

    my $vendor_id = getHardwareVendor();

    my $arch = getArchType();

    my @cpu_cnt = getCpuCount();

    $NoOfCPU = $cpu_cnt[0];

    $NoOfCards = getIOCardCount();

    $hw_name = getHardwareName();

    $memory = getTotalMemory();

    $NoOfBrd = 1 if ($NoOfCPU > 0);

    my $totalDiskCap = 0;

    $totalDiskCap = getTotalDiskSpace();

    $clock = getClockSpeed();

    $host_id = hostOSD::getHostId();
    $system_serial = hostOSD::getSystemSerialNumber();

    print "em_result=$hostname|$domain|$vendor_id|$hw_name|$arch|$clock|$memory|$totalDiskCap|$NoOfCPU|$NoOfBrd|$NoOfCards|$NoOfFan|$NoOfPower|$boot_disk|$system_bios|$system_serial|$avail_mem|$avail_disk|$host_id\n";
 
1;

# End of the Program
