# $Header: hostmessageactivity.pl 04-sep-2003.12:26:31 vsekuboy Exp $
#
# hostmessageactivity.pl
# 
# Copyright (c) 2001, 2003, Oracle Corporation.  All rights reserved.  
#
#    NAME
#      hostmessageactivity.pl 
#
#    DESCRIPTION
#      returns system buffer activity as:
#      em_result=<num msgrcv system calls per sec>|
#                <num of semop sys calls per sec>
#
#    NOTES
#      data collected and averaged over a 5 second interval
#
#    MODIFIED   (MM/DD/YY)
#    vsekuboy    09/04/03 - Fix for HP 
#    vsekuboy    10/28/02 - Combined Linux and OSF1
#    vsekuboy    10/25/02 - Changes for Tru64
#    xxu         06/25/02 - remove /usr/local/bin/perl
#    aaitghez    05/18/01 - sar command message and semaphore activity.
#    aaitghez    05/18/01 - Creation
# 

$ENV{PATH} = "/usr/bin:/bin:/usr/sbin:/usr/local/bin:/local/bin";

chomp ($os = `uname -s`);

if ( $os eq "Linux" || $os eq "OSF1") {
   $qCount = `ipcs -q | wc -l` -4; # Subtract 4 to discount for header and blank lines
   $sCount = `ipcs -s | wc -l` -4; # Subtract 4 to discount for header and blank lines
   print "em_result=$qCount|$sCount\n";
}
elsif ($os eq "SunOS" || $os eq "HP-UX") {

   # invoke sar
   $r = `sar -m 5`
       or die "failed to execute sar";

   #parse the return string into lines
   @res = split(m/sema\/s\n/, $r);
   @values = split(m/[\t\s]+/, @res[1]);

   print "em_result=@values[1]|@values[2]\n";
}
else {
   print "$os is Unsupported Platform\n";
}
