# $Header: emll/sysman/admin/scripts/hostos.pl /main/7 2010/08/03 10:02:46 verangan Exp $
#
# Package : hostos.pl
#
# Copyright (c) 2002, 2010, Oracle and/or its affiliates. All rights reserved. 
#
#   NAME
#       hostos.pl
#
#   DESCRIPTION
#       Collects ECM_OS Metric data
#
#   returns EM_RESULT = 
# with values for
# em_result =NAME|VENDOR|BASE_VERSION|UPDATE_LEVEL|DISTRIBUTOR_VERSION|MAX_SWAP_SPACE_IN_MB|ADDRESS_LENGTH_IN_BITS|MAX_PROCESS_VIRTUAL_MEMORY|TIMEZONE|TIMEZONE_REGION|TIMEZONE_DELTA|PLATFORM_ID|PLATFORM_VERSION_ID|DBM_MEMBER
#
#
#   NOTES
#
#   MODIFIED     (MM/DD/YY)
#      jsutton    06/28/10 - fix typo in check for Database Machine marker
#      jsutton    06/23/10 - Add indicator for DBMachine membership
#      aghanti    06/03/10 - add platform version id
#      glavash    08/30/05 - add platform id 
#      ndutko     08/03/05 - ndutko_code_checkin
#      glavash    04/05/05 - split out from Ptdpm1.pm 
##*************************************************************

use strict;
use File::Spec;
use Config;
use hostOSD;

use constant NIL => '';

#******************************************
#     Global Variables
#******************************************

    my $dist = NIL;
    my $vendor = NIL;
    my $name = NIL;
    my $base = NIL;
    my $update = NIL;
    my $platformId = NIL;
    my $platformVersionId = NIL;

    my @result = getOSNameVendorDist();
    $name = $result[0];
    $vendor = $result[1];
    $dist = $result[2];

    ($base, $update) = split ('-', getOSRelease());

    my $swap = getMaxSwapSpace();

    $swap = sprintf("%.2f", trim($swap) / (1024 * 1024));

    my $address_length = getAddressLength();

    $platformId = getOSPlatformId($name,$vendor,$address_length);
    $platformVersionId = getOSPlatformVersionId($platformId,$name,$base,$vendor);

    # these are NIL only valid NT, and CSA coll
    my $max_proc_virt_mem = NIL;
    my $tz = NIL;
    my $tz_region = NIL;
    my $tz_delta = NIL;

    # locate DB Machine marker file
    my $dbmMarker = "/opt/oracle.cellos";
    my $dbmMember = (-e $dbmMarker ? 1 : 0);

    print "em_result=$name|$vendor|$base|$update|$dist|$swap|$address_length|$max_proc_virt_mem|$tz|$tz_region|$tz_delta|$platformId|$platformVersionId|$dbmMember\n";


sub getOSPlatformVersionId()
{
    my ($platformId, $osName, $baseVer, $osVendor) = @_;

    my $javaFNM = "java";
    if ($Config{'osname'} eq "MSWin32")
    {
        $javaFNM = $javaFNM . ".exe";
    }
    my $javaHomeJava = File::Spec->catdir($ENV{CCR_JAVA_HOME},"bin",$javaFNM);
    my $collectorJar = File::Spec->catdir($ENV{CCR_HOME},"lib","emCCR.jar");

    if (-f $javaHomeJava && -f $collectorJar)
    {
        my $cmd = $javaHomeJava . " -cp $collectorJar"
                  . " oracle.sysman.ccr.collector.targets.host.HostPlatformMap"
                  . " \"$platformId\" \"$osName\" \"$baseVer\" \"$osVendor\"";
        my $platVerId;
        # strip trailing newline from output
        chomp($platVerId = `$cmd`); 
        return $platVerId;
    }
    # default return
    return -1;
}
# End of the Program
