# $Header: hostosfile.pl 18-dec-2006.11:02:54 glavash Exp $
#
# Package : hostosfile.pl
#
# Copyright (c) 2005, 2006, Oracle. All rights reserved.  
#
#   NAME
#       hostosfile.pl
#
#   DESCRIPTION
#       Collects os component data
#
#
#   returns potentially multiple 
# em_result=RESOURCE_NAME|MOUNT_LOCATION|TYPE|MOUNT_OPTIONS|DISK_SPACED_IN_GB|LOCAL_DRIVE|AVAIL_DISK_SPACE_IN_GB
#
#
#   NOTES
#
#   MODIFIED     (MM/DD/YY)
#      glavash    12/14/06 - put in test for NFS disks
#      ndutko     08/03/05 - ndutko_code_checkin
#      glavash    04/05/05 - split out from Ptdpm12.pm 
##*************************************************************

use strict;

use hostOSD;

use ocmprop;

#******************************************
#     Global Variables
#******************************************

    my $result;

#   check if collector.property file has NFS_DISKS set to 1
    my $config_file = "collector.properties";
    my $refProperties = getConfigProperties($config_file);
    my $disk_types = "";
    my $prop_name = "METRIC.HOST.ECM_OS_FILESYSTEM.NFS_ENABLE";
    my $ref_property = $refProperties->{$prop_name};

    # try lower case 
    if (!defined $ref_property)
    {
       $ref_property = $refProperties->{lc $prop_name};
    }

    if (defined $ref_property)
     {
       my $value = uc trim($ref_property->{VALUE});
       if ( $value eq "TRUE")
          {
             $disk_types = 'ALL';
          }
     }
 
    my @file_system_results = getMountedFileSystemResults($disk_types);

    # if we are sorting results sort then print
 
 
    if ($hostOSD::SORT_RESULTS == 1)
    {
      foreach $result (sort(@file_system_results))
      {
        print $result;
      }
    }
    # else print them array by array
    else
    {
      foreach $result (@file_system_results)
      {
        print $result;
      }
    }
1;
# End of the Program
