# Package : hostospatch.pl
#
# Copyright (c) 2011, Oracle and/or its affiliates. All rights reserved. 
#
#   NAME
#       hostospatch.pl
#
#   DESCRIPTION
#       Collects Solaris patch data
#
#   returns EM_RESULT =
# with values for
#| 'ID';
#| 'VENDOR';
#| 'APPLIED_PKGS';
#
#
#   NOTES
#      APPLIED_PKGS is not currently set
#
#   MODIFIED     (MM/DD/YY)
#      jshoup     03/16/11 - Solaris patch retrieval
##*************************************************************

use strict;

use hostOSD;
use Config;
use constant NIL            => '';

#******************************************

# currently only care about Solaris patches
if ($Config{'osname'} eq "solaris")
{
    my $ORACLE = "Oracle";
    my $cmd = $hostOSD::UNAME;
    my $rc = checkCmd($cmd);
    my $id = NIL;
    if ($rc == 1)
    {
        my $os = execCmd($cmd . " -s");

        my @patchIds = getSolarisPatches();
        foreach $id (@patchIds)
        {
            # hardcode the vendor to Oracle
            # leave the applied_pkgs field empty
            print "em_result=$id|$ORACLE|\n";
        }
    }
}

