# $Header: hostosprop.pl 03-aug-2005.08:54:57 ndutko Exp $
#
# Package : hostosprop.pl
#
# Copyright (c) 2005, Oracle. All rights reserved.  
#
#   NAME
#       hostosprop.pl
#
#   DESCRIPTION
#       Collects os property data
#
#
#   returns potentially multiple 
# em_result=SOURCE|NAME|VALUE
#
#
#   NOTES
#
#   MODIFIED     (MM/DD/YY)
#      ndutko     08/03/05 - ndutko_code_checkin
#      glavash    04/05/05 - split out from Ptdpm9.pm 
##*************************************************************

use strict;

use hostOSD;


#******************************************
#     Global Variables
#******************************************

    my $result = ();

    my @sys_def_results = getCurrSysDefnResults();
    my @sys_config_results = getSysConfigResults();
    my @dns_name_server_results = getDNSNameServersResults($hostOSD::METRIC_RESULT);

    # if we are sorting results sort then print
    if ($hostOSD::SORT_RESULTS == 1)
    {
      my @results = ();
      my $i = 0;
      foreach $result (@sys_def_results)
      {
        $results[$i++] = $result;
      }
      foreach $result (@sys_config_results)
      {
        $results[$i++] = $result;
      }
      foreach $result (@dns_name_server_results)
      {
        $results[$i++] = $result;
      }
      foreach $result (sort(@results))
      {
        print $result;
      }
    }
    # else print them array by array
    else
    {
      foreach $result (@sys_def_results)
      {
        print $result;
      }
      foreach $result (@sys_config_results)
      {
        print $result;
      }
      foreach $result (@dns_name_server_results)
      {
        print $result;
      }
    }
1;
# End of the Program
