# $Header: emll/sysman/admin/scripts/hostregsoft.pl /main/5 2012/11/13 18:00:35 davili Exp $
#
# Package : hostregsoft.pl
#
# Copyright (c) 2005, 2012, Oracle and/or its affiliates. All rights reserved. 
#
#   NAME
#       hostregsoft.pl
#
#   DESCRIPTION
#       Collects reg os software component data
#
#
#   returns potentially multiple 
# em_result=id|productname|vendor|version|installdate|installocation|description|sw_info
#
#
#   NOTES
#
#   MODIFIED     (MM/DD/YY)
#      davili     11/05/12 - Bug 14526078, copy logic from host plugin
#      ndutko     02/20/10 - Place the Service Tag appending of
#                            getOSRegisteredSoftwareResults() collected results
#                            here.
#      jsutton    06/23/06 - Force utf8 encoding 
#      ndutko     08/03/05 - ndutko_code_checkin
#      glavash    04/05/05 - split out from Ptdpm8.pm 
##*************************************************************

use strict;

use hostUtil;
use hostOSD;
use hostServiceTags;

use encoding 'utf8';

use constant KEY_NAME_IDX => '1';
use constant KEY_VERSION_IDX => '3';
use constant KEY_INSTALLATION_LOCATION_IDX => '5';

my @key_columns = (KEY_NAME_IDX,KEY_VERSION_IDX,KEY_INSTALLATION_LOCATION_IDX);
my @numaric_columns = ();

#******************************************
#     Global Variables
#******************************************

    my $result = ();

    my @results = getOSRegisteredSoftwareResults();
    my $stResult = ();
    my @stResults = hostServiceTags::getServiceTagEmResults();
    foreach $stResult (sort(@stResults))
    {
        push (@results, $stResult);
    }

    # This make sure that numaric columns should have numeric values and key columns should not be null
    @results = verifyAndUpdateData(\@results,\@key_columns,\@numaric_columns);

    # if we are sorting results sort then print
    if ($hostOSD::SORT_RESULTS == 1)
    {
      foreach $result (sort(@results))
      {
        print $result;
      }
    }
    # else print them without sorting 
    else
    {
      foreach $result (@results)
      {
        print $result;
      }
    }
1;
# End of the Program
