# Package : hostst.pl
#
# Copyright (c) 2002, 2010, Oracle and/or its affiliates. All rights reserved. 
#
#   NAME
#       hostst.pl
#
#   DESCRIPTION
#       Collects Sun service tag registry data
#
#   returns EM_RESULT = 
# with values for
#| 'AGENT_ID';
#| 'AGENT_VERSION';
#| 'REGISTRY_VERSION';
#
# or
#
#|'INSTANCE_URN';
#|'PRODUCT_URN';
#|'AGENT_ID';
#
#   NOTES
#
#   MODIFIED     (MM/DD/YY)
#      ndutko     01/07/10 - Solaris Service Tag registry retrieval
#      ndutko     01/08/10 - ndutko_code_checkin
##*************************************************************

use strict;
use ias::simpleXPath;
use hostServiceTags; 

require "$ENV{EMDROOT}/sysman/admin/scripts/semd_common.pl";
#******************************************
#     Global Variables
#******************************************

use constant NIL            => '';
use constant PRODUCT_URN     => 'product_urn';
use constant INSTANCE_URN     => 'instance_urn';
use constant SERVICE_TAG     => 'service_tag';
use constant REGISTRY => 'registry';
use constant INSTANCE => 'instance';
use constant DELIM => '|';

# first argument is registry or instance
my $type = $ARGV[0];

# helper function to extract element value
sub getStringValue
{
    my $nodeRef = $_[0];

    if (${$nodeRef}{'type'} eq 'text')
    {
        return ${$nodeRef}{'text'};
    }

    my @childText = map(getStringValue($_), @{$$nodeRef{'children'}});
    return join('', @childText);
}

# instance data
sub getInstance
{
    # return array
    my @result = ();
	
    my $xml = getServiceTagsXml();
    if ($xml eq NIL) {
        return @result;
    }
    my @agents = simpleXPathQueryForTextNodes($xml, "registry/service_tag");
 
    for my $agent (@agents) {
	my $instanceUrn   = NIL;
	my $productUrn   = NIL;
        for my $childNode (@{$$agent{'children'}}) {
			
            if ($$childNode{'tagName'} eq "") {
                next;
            }

            my $tagName = $$childNode{'tagName'};
            my $tagValue = "";
            my @children = $$childNode{'children'};

            for my $childRef (@children) {
                $tagValue = getStringValue($childNode);
            }
            
            if ($tagName eq INSTANCE_URN) {
                $instanceUrn = $tagValue;
            }
            
            if ($tagName eq PRODUCT_URN) {
                $productUrn = $tagValue;
            }
        }
        
        if ($instanceUrn ne NIL and $productUrn ne NIL) {
	    push(@result,$instanceUrn . DELIM . $productUrn);
	}
    }
    return @result;
}

if ($type =~ /${\(REGISTRY)}/i) {
	my $agentUrn = getAgentUrn();
	my $agentVersion = getAgentVersion();
	my $registryVersion = getRegistryVersion();
	if ($agentUrn ne NIL and $agentVersion ne NIL and $registryVersion ne NIL) {
            print "em_result=" . $agentUrn . DELIM . $agentVersion . DELIM . $registryVersion . "\n";
	}
}

if ($type =~ /${\(INSTANCE)}/i) {
	#get tags
	my @instances = getInstance();
	#if we have some tags output
	if (@instances != 0) {
		for my $instance (@instances) {
			print "em_result=" . $instance . "\n";
		}
	}
}
1;

# End of the Program
