# $Header: hosttablesstatus.pl 15-mar-2005.13:31:59 qding Exp $
#
# hosttablesstatus.pl
# 
# Copyright (c) 2001, 2005, Oracle. All rights reserved.  
#
#    NAME
#      hosttablesstatus.pl 
#
#    DESCRIPTION
#      returns system tables stats as:
#      em_result=<current and max size of process table>|
#                <process table overflow occurences between sampling points>|
#                <current and maximum size of i-node table>|
#                <i-node table overflow occurences between sampling points>|
#                <current and max size of sys file table>|
#                <file table overflow occurences between sampling points>
#
#    NOTES
#       data collected and averaged over a 5 second interval
#
#    MODIFIED   (MM/DD/YY)
#    qding       03/15/05 - set locale to C 
#    skumar      02/13/04 - AIX and Linux changes 
#    xxu         06/25/02 - remove /usr/local/bin/perl
#    aaitghez    10/24/01 - splitting columns..
#    aaitghez    05/18/01 - sar metric system tables stats.
#    aaitghez    05/18/01 - Creation
# 

$ENV{LC_ALL} = "C";
$ENV{PATH} = "/usr/bin:/bin:/usr/sbin:/usr/local/bin:/local/bin";

if ($^O eq "SunOS" or $^O eq "solaris")
{
  # invoke sar
  $r = `sar -v 5`
    or die "failed to execute sar";

  @res = split(m/lock-sz\n/, $r);
  @values = split(m/[\t\s]+/, @res[1]);
  @procsz = split("/", @values[1]);
  @inodsz = split("/", @values[3]);
  @filesz = split("/", @values[5]);
  print "em_result=@procsz[0]|@procsz[1]|@values[2]|@inodsz[0]|@inodsz[1]|@values[4]|@filesz[0]|@filesz[1]|@values[6]\n"; 
}
elsif ($^O eq "hpux")
{
  # invoke sar
  $r = `sar -v 5`
    or die "failed to execute sar";
  @res = split(m/file-sz(.)+ov/, $r);
  @values = split(m/[\t\s]+/, @res[2]);
  @procsz = split("/", @values[4]);
  @inodsz = split("/", @values[6]);
  @filesz = split("/", @values[8]);
  print "em_result=@procsz[0]|@procsz[1]|@values[5]|@inodsz[0]|@inodsz[1]|@values[7]|@filesz[0]|@filesz[1]|@values[9]\n";
}
elsif ($^O eq "aix")
{
  @r = `sar -v `
    or die "failed to execute sar";
  ($ignore, $proc_sz, $inod_sz, $file_sz) = split(/\s+/, $r[$#r-1]);
  ($proc_sz, $max_proc_sz) = split(/\//, $proc_sz);
  ($inod_sz, $max_inod_sz) = split(/\//, $inod_sz);
  ($file_sz, $max_file_sz) = split(/\//, $file_sz);
  print "em_result=$proc_sz|$max_proc_sz|0|$inod_sz|$max_inod_sz|0|$file_sz|$max_file_sz|0\n";
}
elsif ($^O eq "linux")
{
  # dentunusd
  #   Number of unused cache entries in the direc
  #   tory cache.
  #
  # file-sz
  #   Number of used file handles.
  #
  # %file-sz
  #   Percentage of used file handles with  regard
  #   to  the  maximum number of file handles that
  #   the Linux kernel can allocate.
  #
  # inode-sz
  #   Number of used inode handlers.
  #
  # super-sz
  #   Number of super block handlers allocated  by
  #   the kernel.
  #
  # %super-sz
  #   Percentage of allocated super block handlers
  #   with regard to the maximum number  of  super
  #   block handlers that Linux can allocate.
  #
  # dquot-sz
  #   Number of allocated disk quota entries.
  #
  # %dquot-sz
  #   Percentage  of  allocated disk quota entries
  #   with regard to the maximum number of  cached
  #   disk quota entries that can be allocated.
  #
  # rtsig-sz
  #   Number of queued RT signals.
  #
  # %rtsig-sz
  #   Percentage  of queued RT signals with regard
  #   to the maximum number of RT signals that can
  #   be queued.
  
  @sarv = `sar -v `
    or die "failed to execute sar";
  my $format = @sarv[0];
  if ($format =~ /%file-sz/) 
  {
    ($ignore, $dentunusd, $file_sz, $pfile_sz, $inode_sz, $super_sz, $psuper_sz, $dquot_sz, $pdquot_sz, $rtsig_sz, $prtsig_sz) = split(/\s+/, $sarv[$#sarv]);
  }
  else
  {
    ($ignore, $dentunusd, $file_sz, $inode_sz, $super_sz, $psuper_sz, $dquot_sz, $pdquot_sz, $rtsig_sz, $prtsig_sz) = split(/\s+/, $sarv[$#sarv]);
  }  
  print "em_result=$file_sz|$pfile_sz|$inode_sz|$super_sz|$psuper_sz|$dquot_sz|$pdquot_sz|$rtsig_sz|$prtsig_sz\n";
}
else
{
  die "unsupported platform";
}

exit 0;

