#!/usr/local/bin/perl
# 
# $Header: httpd_esm.pl 24-may-2005.23:13:23 rkuriako Exp $
#
# httpd_esm.pl
# 
# Copyright (c) 2003, 2005, Oracle. All rights reserved.  
#
#    NAME
#      httpd_esm.pl - <one-line expansion of the name>
#
#    DESCRIPTION
#      ESM script for checking httpd security violations.
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    rkuriako    05/24/05 - bug-4370144
#    rkuriako    05/03/05 - bug-4188709
#    kchander    11/26/03 - kchander_esm_scripts_for_ias 
#    kchander    11/26/03 - make final changes
#    kchander    10/28/03 - Creation
# 
use File::Find;
use Digest::MD5;
use strict;
my $oraHome = $ENV{ORACLE_HOME};
our $writeableFileCount = 0;
my $sep = $^O =~ m/MSWin32/ ? "\\" : "\/";
my $httpdConf = $oraHome.$sep."Apache".$sep."Apache".$sep."conf".$sep."httpd.conf";
my @confarray = ();
my $docRoot;
if (open HTTPDCONF, "<$httpdConf")
{
    my $in;
    while ($in = <HTTPDCONF>)
    {
        chomp($in);
        $in =~ s/^\s+//;
        $in =~ s/\s+$//;
        push(@confarray, $in);
    }
    @confarray = grep(!/^#/, @confarray);
    close HTTPDCONF;



#check whether access logging is enabled or not.
    my @array = grep(/CustomLog/, @confarray);
    if ($#array < 0)
    {
        print "em_result=ApacheAccessLogging|disabled\n";
    }
    else
    {
        print "em_result=ApacheAccessLogging|enabled\n";
    }
#check whether directory indexing is on
    @array = grep(/Options/, @confarray);
    my @indArr = grep(/Indexes/,@array);
    for (my $j =0; $j<=$#indArr; $j++)
    {
        $indArr[$j] =~ s/^\s+//;
    }
    @indArr = grep(!/^#/, @indArr);
    if ($#indArr == -1)
    {
        print "em_result=ApacheDirectoryIndexing|disabled\n";
    }
    else
    {
        print "em_result=ApacheDirectoryIndexing|enabled\n";
    }
    my $httpd = $oraHome.$sep."Apache".$sep."Apache".$sep."bin".$sep."httpd";
    my @attr=stat($httpd);
    #check whether httpd is owned by root and setuid bit is on
    if ( ($attr[4] == 0) and ($attr[2] & 04000))
    {
        print "em_result=HttpdProcessOwnedBy|root\n";
    }
    else 
    {
        print "em_result=HttpdProcessOwnedBy|non_root\n";
    }
    #test all the static files in DocumentRoot are read only
    @array = grep(/DocumentRoot/, @confarray);

    for (my  $j =0; $j<=$#array; $j++)
    {
        $array[$j] =~ s/^\s+//;
    }
    @array = grep(!/^#/, @array);
    for (my $i=0; $i<=$#array; $i++)
    {
        $docRoot = substr($array[$i], 12);
        $docRoot =~ s/^\s+//; 
        my $in = index($docRoot, "\"", 1);
	$docRoot = substr($docRoot, 1, $in-1);
        $writeableFileCount = 0;
        find(\&checkFiles, $docRoot);
        if ($writeableFileCount >= 0)
        {
            print "em_result=OHSWritableFile_$i|$writeableFileCount\n";            
        }
    }

}
#check whether HTTP Server is runing on SSO or not.
my $ssl = checkSSLON();
if (checkSSLON() == -1)
{
    print "em_result=OHSSSLEnable|off\n";
}
else
{
    print "em_result=OHSSSLEnable|on\n";
}
#check whether Dummy wallet is being used in production
if (checkSSLON() == 1)
{
    my $defaultDigest = "SF71BJSZvzb+2xrJQOKH+w";
    my  $sslconf = $oraHome.$sep."Apache".$sep."Apache".$sep."conf".$sep."ssl.conf";
    my  @sslconffile = ();
    if (open SSLCONF, "<$sslconf")
    {
        my $line;
        while ($line = <SSLCONF>)
        {
            chomp($line);
            $line =~s/^\s+//;
            $line =~s/\s+$//;
            if (grep(/SSLWallet/, $line))
            {                
                push(@sslconffile, $line);
            }
        }

        @sslconffile = grep(!/^#/, @sslconffile);
        my $file;
        foreach $file (@sslconffile)
        {
            my $ind = index($file, "file:");
            my $walletdir;
            if (grep(/#/, $file))
            {
                my $in = index($file, "#", $ind);
                $walletdir= substr($file, $ind+5, $in - ($ind+5));
            }
            else
            {
                $walletdir = substr($file,$ind+5);
            }

            $walletdir =~s/^\s+//;
            $walletdir =~s/\s+$//;

            my $defaultCert = $walletdir."/ewallet.p12";
            if (open DEFCER ,$defaultCert)
            {
                binmode(DEFCER);
                my $md5 = Digest::MD5->new;
                while(<DEFCER>)
                {
                    $md5->add($_);
                }
                close DEFCER;
                my  $di= $md5->b64digest;
#                print "digest $di\n";
                if ($di eq $defaultDigest)
                {
                    print "em_result=OHSDummyWallet|used\n";
                }
                else
                {
                    print "em_result=OHSDummyWallet|not_used\n";
                }
            }

        }
        close SSLCONF;
    }



}
sub checkSSLON
{
    my $opmnLoc = $oraHome.$sep."opmn".$sep."conf".$sep."opmn.xml";
    if (open OPMN, "<$opmnLoc")
    {
        my @arr = ();
        my $line;
        while( $line = <OPMN>)
        {
            chomp($line);
            $line =~s/^\s+//;
            $line =~ s/\s+$//;
            if ( grep(/^<ias-component/,$line) and grep(/HTTP_Server/, $line))
            {
                my $i =0;
                $arr[$i++] = $line;
                while (my $in = <OPMN>)
                {
                    chomp($in);
                    $in =~s/^\s+//;
                    $in =~ s/\s+$//;
                    $arr[$i] = $in;
                    $i++;
                    if ( $in eq "</ias-component>")
                    {
                        last;
                    }
                }
            }
        }

        #print "array is @arr\n";
        @arr = grep(/ssl-enabled/, @arr);
        if ( $#arr == -1 )
        {
            #print "em_result=OHSSSLEnable|off\n";
            return -1;
        }
        else
        {
            return 1;
        }
        close OPMN;
    }

}
sub checkFiles
{
    my  $currentFile = $_;
    if (!(  -d $currentFile))
    {
        my @fileattr = stat($currentFile);
        # print "$currentFile\n";
        if (($fileattr[2] & 020)or ($fileattr[2] & 2))
        {
            $writeableFileCount++;
        }
    }
}
