#!/usr/local/bin/perl
# 
# $Header: emll/sysman/admin/scripts/iam/dip/getDIPAdminDetail.pl /main/1 2010/08/16 22:31:17 proxy Exp $
#
# getDIPAdminDetail.pl
# 
# Copyright (c) 2010, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      getDIPAdminDetail.pl - <one-line expansion of the name>
#
#    DESCRIPTION
#      This file reads configuration metric DIPAdminServerJMX for oracle_eps_server target
#
#    NOTES
#      Picks up Admin Server details from targets.xml
#
#    MODIFIED   (MM/DD/YY)
#    proxy       06/29/10 - Creation
# 

use strict;
use ias::simpleXPath;
use ias::asecm;
use File::Spec;

my $domainHome = $ARGV[0];
my $targetName = $ARGV[1];
my $server = $ARGV[2];
my $port = $ARGV[3];

my $adminHost="";
my $adminPort="";
my $domainName="";

my $emagentString = File::Spec->catfile("EMAGENT","EMAGENT","sysman","emd","targets.xml");

#get topology.xml for the given domain
my $topologyFile = File::Spec->catfile("$domainHome","opmn","topology.xml");

if(-e $topologyFile){
	my $topologyConfig = ias::simpleXPath::parseFile("$topologyFile");
	#parse topology and select instances
	my @instanceNodes = ias::simpleXPath::queryForNodes($topologyConfig, 'topology/ias-instance');
	my $hashSize = scalar(@instanceNodes);

	#for every instance check the targets.xml for the given target
	for(my $count=0; $count < $hashSize; $count++)
	{
		my $instanceHome = ias::simpleXPath::getAttribute($instanceNodes[$count], "instance-home");
		my $targetsFile = File::Spec->catfile("$instanceHome","$emagentString");
		if(-e $targetsFile)
		{
			my $targetsConfig = ias::simpleXPath::parseFile("$targetsFile");
			#get all targets of type oracle_eps_server
			my @nodes = ias::simpleXPath::queryForNodes($targetsConfig, 'Targets/Target[@TYPE="oracle_eps_server"]');
			my $nodeHash = scalar(@nodes);

			for(my $cnt=0; $cnt<$nodeHash; $cnt++)
			{	
				#select the one with the same name
				my $name = ias::simpleXPath::getAttribute($nodes[$cnt], "NAME");
				if($name eq $targetName)
				{
					#check whether it has same admin server and port
					my $serverName="";
					my $serverPort="";
					my @propNodes = ias::simpleXPath::queryForNodes($nodes[$cnt], 'Target/Property[@NAME="MachineName"]');
					if(scalar(@propNodes)>0)
					{
						$serverName = ias::simpleXPath::getAttribute($propNodes[0], "VALUE");
					}
					@propNodes = ias::simpleXPath::queryForNodes($nodes[$cnt], 'Target/Property[@NAME="Port"]');
					if(scalar(@propNodes)>0)
					{
						$serverPort = ias::simpleXPath::getAttribute($propNodes[0], "VALUE");
					}

					if($serverName eq $server && $serverPort eq $port)
					{
						$adminHost = $serverName;
						$adminPort = $serverPort;
						#get the domain name
						my @assocNodes = ias::simpleXPath::queryForNodes($nodes[$cnt], 'Target/AssocTargetInstance[@ASSOC_TARGET_TYPE="weblogic_domain"]');
						if(scalar(@assocNodes)>0)
						{
							$domainName = ias::simpleXPath::getAttribute($assocNodes[0], "ASSOC_TARGET_NAME");
							ias::asecm::printResult(
								$adminHost,      'string',
							    $adminPort,    'string',
								$domainName,	'string', 
							);
							exit;
						}
					}
				}
			}
		}	
	}
}