#!/usr/local/bin/perl
# 
# $Header: emll/sysman/admin/scripts/iam/dip/getDIPConfigDetail.pl /main/2 2010/08/16 22:31:17 proxy Exp $
#
# getDIPConfigDetail.pl
# 
# Copyright (c) 2010, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      getDIPConfigDetail.pl - <one-line expansion of the name>
#
#    DESCRIPTION
#      This file reads configuration metric DIPConfigMetric for oracle_eps_server target
#
#    NOTES
#      Reads from file dip-config.xml and picks out the required data for the configuration metric.
#
#    MODIFIED   (MM/DD/YY)
#    proxy       04/23/10 - Creation
# 

use strict;
use ias::simpleXPath;
use File::Spec;
use ias::asecm;

my $domainHome = $ARGV[0];
my $serverName = $ARGV[1];

my $xmlFile;

my $xmlFile1 = File::Spec->catfile("$domainHome","server","$serverName","stage","DIP","11.1.1.1.0","DIP","configuration","dip-config.xml");
my $xmlFile2 = File::Spec->catfile("$domainHome","config","fmwconfig","servers","$serverName","applications","DIP_11.1.1.2.0","configuration","dip-config.xml");
my $xmlFile3 = File::Spec->catfile("$domainHome","config","fmwconfig","servers","$serverName","applications","DIP_11.1.1.3.0","configuration","dip-config.xml");
if(-e $xmlFile1){
	$xmlFile = $xmlFile1;
}
elsif(-e $xmlFile2){
	$xmlFile = $xmlFile2;
}
elsif(-e $xmlFile3){
	$xmlFile = $xmlFile3;
}

my @oid;
my $oidNodeHost="";
my $oidNodePort="";
my $refreshInterval="";
my $sslMode="";

@oid = ias::simpleXPath::simpleXPathQueryForText($xmlFile,'DIPConfig/OID_NODE_HOST');
$oidNodeHost = $oid[0];
@oid = ias::simpleXPath::simpleXPathQueryForText($xmlFile,'DIPConfig/OID_NODE_PORT');
$oidNodePort = $oid[0];
@oid = ias::simpleXPath::simpleXPathQueryForText($xmlFile, 'DIPConfig/REFRESH_INTERVAL');
$refreshInterval = $oid[0];
@oid = ias::simpleXPath::simpleXPathQueryForText($xmlFile, 'DIPConfig/SSL_MODE');
$sslMode = $oid[0];

ias::asecm::printResult(
     $oidNodeHost,      'string',
     $oidNodePort,    'string',
     $sslMode,   'number',
     $refreshInterval,   'number',
);
