#!/usr/local/bin/perl
# 
# $Header: emll/sysman/admin/scripts/iam/oid/getOIDLogDetail.pl /main/2 2010/08/16 22:31:17 proxy Exp $
#
# getOIDLogDetail.pl
# 
# Copyright (c) 2010, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      getOIDLogDetail.pl - <one-line expansion of the name>
#
#    DESCRIPTION
#      This file reads configuration metric OIDLogConfigMetric for oracle_ldap target
#
#    NOTES
#      Reads from file oidconfig_xml and picks out the required data for the configuration metric.
#
#    MODIFIED   (MM/DD/YY)
#    proxy       05/19/10 - Creation
# 

use strict;
use File::Spec;

my $oracleInstance = $ARGV[0];
my $targetName = $ARGV[1];

#Extract display name from the target name. The display name is the substring after the last occurence of '/'.
my $slash = '/';
my $indexOf = rindex($targetName,$slash);
my $displayName = substr($targetName,$indexOf+1);
my $pName;

my $xmlFile = File::Spec->catfile("$oracleInstance","config","OID","$displayName","oidconfig_xml");

open(OUT, $xmlFile);

my @propName = ("orcldebugflag","orcldebugop","orclmaxlogfilesize","orclmaxlogfiles");
my @results;
my $res;
my $line;

while($line = <OUT>)
{
	 chomp($line);
     push(@results, $line);
}

close(OUT);

foreach $pName (@propName)
{
    my $r='';
    IN: foreach $line (@results)
    {
        if ($line =~ m/$pName/)
        {
        	$r = substr($line, (index($line, '=')+1));
	        $r =~ s/\r//g;
			last IN;
        }
    }
    $res =  $res."|".$r;
}

$res = substr($res, 1);
print "em_result=$res\n";