#!/usr/local/bin/perl
# 
# $Header: emll/sysman/admin/scripts/iam/oid/getOIDSaslDetail.pl /main/2 2010/08/16 22:31:17 proxy Exp $
#
# getOIDSaslDetail.pl
# 
# Copyright (c) 2010, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      getOIDSaslDetail.pl - <one-line expansion of the name>
#
#    DESCRIPTION
#      This file reads configuration metric OIDSASLConfigMetric for oracle_ldap target
#
#    NOTES
#      Reads from file oidconfig_xml and picks out the required data for the configuration metric
#
#    MODIFIED   (MM/DD/YY)
#    proxy       05/19/10 - Creation
# 

use strict;
use File::Spec;

my $oracleInstance = $ARGV[0];
my $targetName = $ARGV[1];

#Extract display name from the target name. The display name is the substring after the last occurence of '/'.
my $slash = '/';
my $indexOf = rindex($targetName,$slash);
my $displayName = substr($targetName,$indexOf+1);
my $pName;

my $xmlFile = File::Spec->catfile("$oracleInstance","config","OID","$displayName","oidconfig_xml");

open(OUT, $xmlFile);

my @propName = ("orclsaslauthenticationmode","orclsaslcipherchoice","orclsaslmechanism");
my @results;
my $external = "EXTERNAL";
my $md = "DIGEST-MD5";
my $notExternal = "external";
my $externalFlag = "false";
my $mdFlag = "false";
my $mechFlag = "false";
my $res;
my $cipherChoice;
my $line;

while($line = <OUT>)
{
	 chomp($line);
     push(@results, $line);
}

close(OUT);

foreach $pName (@propName)
{
	my $r ='';
	IN: foreach $line (@results)
    {
		if ($line =~ m/$pName/)
        {
			if($pName eq "orclsaslmechanism")
            {
				$r = substr($line, (index($line, '=')+1));
                $r =~s /\r//g;
				if($r ne '')
				{
					$mechFlag = "true";
	                if ($r eq $external) {
						$externalFlag = "true";
			        }
				    elsif($r eq $md){
					    $mdFlag = "true";
				    }
					elsif($r eq $notExternal) {
						$externalFlag = "false";
	                }
				}
            }
            elsif($pName eq "orclsaslcipherchoice")
            {
				$r = substr($line, (index($line, '=')+1));
                $r =~s /\r//g;
				if($r ne '')
				{
	                if($cipherChoice)
		            {
						$cipherChoice = $cipherChoice . " , " . $r;
					}
				    else
	                {
						$cipherChoice = $r;
			        }
				}
            }
            else
            {
				$r = substr($line, (index($line, '=')+1));
                $r =~ s/\r//g;
				last IN;
            }
        }
	}
	if(($pName ne "orclsaslmechanism") && ($pName ne "orclsaslcipherchoice"))
	{
		 $res =  $res."|".$r;
	}
}

if($mechFlag eq "true")
{
	if(($externalFlag eq "true") && ($mdFlag eq "true")){
		$res = $res."|".$cipherChoice."|".$external."|".$md;
	}

	else{
		$res = $res."|".$cipherChoice."|".$notExternal."| |";
	}
}

else
{
	$res = $res."|".$cipherChoice."| | |";
}

$res = substr($res, 1);
print "em_result=$res\n";