#!/usr/local/bin/perl
# 
# $Header: emll/sysman/admin/scripts/iam/oif/getOIFDSConfigDetail.pl /main/2 2010/08/16 22:31:17 proxy Exp $
#
# getOIFDSConfigDetail.pl
# 
# Copyright (c) 2010, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      getOIFDSConfigDetail.pl - <one-line expansion of the name>
#
#    DESCRIPTION
#      This file reads configuration metric OIFDataStoreConfigMetric for oracle_federation target
#
#    NOTES
#      Reads from file config.xml and picks out the required data for the configuration metric.
#
#    MODIFIED   (MM/DD/YY)
#    proxy       05/04/10 - Creation
# 

use strict;
use ias::simpleXPath;
use ias::asecm;
use File::Spec;
my $domainHome = $ARGV[0];
my $serverName = $ARGV[1];

my $xmlFile; 

my $xmlFile1 = File::Spec->catfile("$domainHome","server","$serverName","stage","OIF","11.1.1.1.0","OIF","configuration","config.xml");
my $xmlFile2 = File::Spec->catfile("$domainHome","config","fmwconfig","servers","$serverName","applications","OIF_11.1.1.2.0","configuration","config.xml");
my $xmlFile3 = File::Spec->catfile("$domainHome","config","fmwconfig","servers","$serverName","applications","OIF_11.1.1.3.0","configuration","config.xml");
if(-e $xmlFile1){
	$xmlFile = $xmlFile1;
}
elsif(-e $xmlFile2){
	$xmlFile = $xmlFile2;
}
elsif(-e $xmlFile3){
	$xmlFile = $xmlFile3;
}

my @oif;

my $fedLdapSvrUrl="";
my $fedBindDN="";
my $fedUserRcrdCtx="";
my $fedLdapConClass="";
my $fedLdapUnique="";
my $fedMaxConn="";
my $fedConnWait="";
my $fedRdbmsJndi="";
my $usrLdapSvrUrl="";
my $usrBindDN="";
my $usrLdapIdAttr="";
my $usrLdapDescAttr="";
my $usrObjClass="";
my $usrBaseDN="";
my $usrMaxConn="";
my $usrConnWait="";
my $usrRdbmsJndi="";
my $usrLoginTable="";
my $usrRdbmsIdAttr="";
my $usrRdbmsDescAttr="";

@oif = ias::simpleXPath::simpleXPathQueryForText($xmlFile,'FederationConfig//Config[@name="datastore"]//Property[@name="fedldapserverurls"]');
$fedLdapSvrUrl = $oif[0];
@oif = ias::simpleXPath::simpleXPathQueryForText($xmlFile,'FederationConfig//Config[@name="datastore"]//Property[@name="fedldapusername"]');
$fedBindDN = $oif[0];
@oif = ias::simpleXPath::simpleXPathQueryForText($xmlFile,'FederationConfig//Config[@name="datastore"]//Property[@name="fedldapuserfedrecordcontext"]');
$fedUserRcrdCtx = $oif[0];
@oif = ias::simpleXPath::simpleXPathQueryForText($xmlFile,'FederationConfig//Config[@name="datastore"]//Property[@name="fedldapcontainerclass"]');
$fedLdapConClass = $oif[0];
@oif = ias::simpleXPath::simpleXPathQueryForText($xmlFile,'FederationConfig//Config[@name="datastore"]//Property[@name="fedldapuniquefedid"]');
$fedLdapUnique = $oif[0];
@oif = ias::simpleXPath::simpleXPathQueryForText($xmlFile,'FederationConfig//Config[@name="datastore"]//Property[@name="fedldapmaxconnections"]');
$fedMaxConn = $oif[0];
@oif = ias::simpleXPath::simpleXPathQueryForText($xmlFile,'FederationConfig//Config[@name="datastore"]//Property[@name="fedldapconnectionwaittimeout"]');
$fedConnWait = $oif[0];
@oif = ias::simpleXPath::simpleXPathQueryForText($xmlFile,'FederationConfig//Config[@name="datastore"]//Property[@name="fedrdbmsjndiname"]');
$fedRdbmsJndi = $oif[0];
@oif = ias::simpleXPath::simpleXPathQueryForText($xmlFile,'FederationConfig//Config[@name="datastore"]//Property[@name="userldapserverurls"]');
$usrLdapSvrUrl = $oif[0];
@oif = ias::simpleXPath::simpleXPathQueryForText($xmlFile,'FederationConfig//Config[@name="datastore"]//Property[@name="userldapusername"]');
$usrBindDN = $oif[0];
@oif = ias::simpleXPath::simpleXPathQueryForText($xmlFile,'FederationConfig//Config[@name="datastore"]//Property[@name="userldapuseridattr"]');
$usrLdapIdAttr = $oif[0];
@oif = ias::simpleXPath::simpleXPathQueryForText($xmlFile,'FederationConfig//Config[@name="datastore"]//Property[@name="userldapuserdescriptionattr"]');
$usrLdapDescAttr = $oif[0];
@oif = ias::simpleXPath::simpleXPathQueryForText($xmlFile,'FederationConfig//Config[@name="datastore"]//Property[@name="userldappersonobjclass"]');
$usrObjClass = $oif[0];
@oif = ias::simpleXPath::simpleXPathQueryForText($xmlFile,'FederationConfig//Config[@name="datastore"]//Property[@name="userldapbasedn"]');
$usrBaseDN = $oif[0];
@oif = ias::simpleXPath::simpleXPathQueryForText($xmlFile,'FederationConfig//Config[@name="datastore"]//Property[@name="userldapmaxconnections"]');
$usrMaxConn = $oif[0];
@oif = ias::simpleXPath::simpleXPathQueryForText($xmlFile,'FederationConfig//Config[@name="datastore"]//Property[@name="userldapconnectionwaittimeout"]');
$usrConnWait = $oif[0];
@oif = ias::simpleXPath::simpleXPathQueryForText($xmlFile,'FederationConfig//Config[@name="datastore"]//Property[@name="userrdbmsjndiname"]');
$usrRdbmsJndi = $oif[0];
@oif = ias::simpleXPath::simpleXPathQueryForText($xmlFile,'FederationConfig//Config[@name="datastore"]//Property[@name="userrdbmstablename"]');
$usrLoginTable = $oif[0];
@oif = ias::simpleXPath::simpleXPathQueryForText($xmlFile,'FederationConfig//Config[@name="datastore"]//Property[@name="userrdbmsuseridattr"]');
$usrRdbmsIdAttr = $oif[0];
@oif = ias::simpleXPath::simpleXPathQueryForText($xmlFile,'FederationConfig//Config[@name="datastore"]//Property[@name="userrdbmsuserdescriptionattr"]');
$usrRdbmsDescAttr = $oif[0];

ias::asecm::printResult(
	$fedLdapSvrUrl, 'string',
	$fedBindDN, 'string',
	$fedUserRcrdCtx, 'string',
	$fedLdapConClass, 'string',
	$fedLdapUnique, 'string',
	$fedMaxConn, 'number',
	$fedConnWait, 'number',
	$fedRdbmsJndi, 'string',
	$usrLdapSvrUrl, 'string',
	$usrBindDN, 'string',
	$usrLdapIdAttr, 'string',
	$usrLdapDescAttr, 'string',
	$usrObjClass, 'string',
	$usrBaseDN, 'string',
	$usrMaxConn, 'number',
	$usrConnWait, 'number',
	$usrRdbmsJndi, 'string',
	$usrLoginTable, 'string',
	$usrRdbmsIdAttr, 'string',
	$usrRdbmsDescAttr, 'string',
);