#!/usr/local/bin/perl
# 
# $Header: emll/sysman/admin/scripts/iam/oif/getOIFIdPConfigDetail.pl /main/2 2010/08/16 22:31:17 proxy Exp $
#
# getOIFIdPConfigDetail.pl
# 
# Copyright (c) 2010, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      getOIFIdPConfigDetail.pl - <one-line expansion of the name>
#
#    DESCRIPTION
#      This file reads configuration metric OIFIdPConfigMetric for oracle_federation target
#
#    NOTES
#      Reads from file config.xml and picks out the required data for the configuration metric.
#
#    MODIFIED   (MM/DD/YY)
#    proxy       05/04/10 - Creation
# 

use strict;
use ias::simpleXPath;
use ias::asecm;
use File::Spec;
my $domainHome = $ARGV[0];
my $serverName = $ARGV[1];

my $xmlFile; 

my $xmlFile1 = File::Spec->catfile("$domainHome","server","$serverName","stage","OIF","11.1.1.1.0","OIF","configuration","config.xml");
my $xmlFile2 = File::Spec->catfile("$domainHome","config","fmwconfig","servers","$serverName","applications","OIF_11.1.1.2.0","configuration","config.xml");
my $xmlFile3 = File::Spec->catfile("$domainHome","config","fmwconfig","servers","$serverName","applications","OIF_11.1.1.3.0","configuration","config.xml");
if(-e $xmlFile1){
	$xmlFile = $xmlFile1;
}
elsif(-e $xmlFile2){
	$xmlFile = $xmlFile2;
}
elsif(-e $xmlFile3){
	$xmlFile = $xmlFile3;
}

my @oif;

my $enableIdp="";
my $providerId="";
my $assertionValid="";
my $reauthenticate="";
my $sendSignAssert="";
my $artifactTimeout="";
my $enableCmnDomain="";
my $cmnDomainUrl="";
my $cmnDomainName="";
my $cmnDmnCookieLife="";
my $ssoMode="";
my $ssoUserAttr="";
my $ssoAttrValue="";
my $forceAuth="";

@oif = ias::simpleXPath::simpleXPathQueryForText($xmlFile,'FederationConfig//Config[@name="idpglobal"]//Property[@name="idpenabled"]');
$enableIdp = $oif[0];
@oif = ias::simpleXPath::simpleXPathQueryForText($xmlFile,'FederationConfig//Config[@name="idpglobal"]//Property[@name="providerid"]');
$providerId = $oif[0];
@oif = ias::simpleXPath::simpleXPathQueryForText($xmlFile,'FederationConfig//Config[@name="idpglobal"]//Property[@name="assertionvalidityinterval"]');
$assertionValid = $oif[0];
@oif = ias::simpleXPath::simpleXPathQueryForText($xmlFile,'FederationConfig//Config[@name="idpglobal"]//Property[@name="reauthenticate"]');
$reauthenticate = $oif[0];
@oif = ias::simpleXPath::simpleXPathQueryForText($xmlFile,'FederationConfig//Config[@name="idpglobal"]//Property[@name="sendsignedassertion"]');
$sendSignAssert = $oif[0];
@oif = ias::simpleXPath::simpleXPathQueryForText($xmlFile,'FederationConfig//Config[@name="idpglobal"]//Property[@name="artifacttimeout"]');
$artifactTimeout = $oif[0];
@oif = ias::simpleXPath::simpleXPathQueryForText($xmlFile,'FederationConfig//Config[@name="idpglobal"]//Property[@name="commondomainenabled"]');
$enableCmnDomain = $oif[0];
@oif = ias::simpleXPath::simpleXPathQueryForText($xmlFile,'FederationConfig//Config[@name="idpglobal"]//Property[@name="commondomainurl"]');
$cmnDomainUrl = $oif[0];
@oif = ias::simpleXPath::simpleXPathQueryForText($xmlFile,'FederationConfig//Config[@name="idpglobal"]//Property[@name="commondomainname"]');
$cmnDomainName = $oif[0];
@oif = ias::simpleXPath::simpleXPathQueryForText($xmlFile,'FederationConfig//Config[@name="idpglobal"]//Property[@name="commondomaincookielifetime"]'); 
$cmnDmnCookieLife = $oif[0];
@oif = ias::simpleXPath::simpleXPathQueryForText($xmlFile,'FederationConfig//Config[@name="idpglobal"]//Property[@name="optssouser"]');
$ssoMode = $oif[0];
@oif = ias::simpleXPath::simpleXPathQueryForText($xmlFile,'FederationConfig//Config[@name="idpglobal"]//Property[@name="optssouserattrname"]');
$ssoUserAttr = $oif[0];
@oif = ias::simpleXPath::simpleXPathQueryForText($xmlFile,'FederationConfig//Config[@name="idpglobal"]//Property[@name="optssouserattrvalue"]');
$ssoAttrValue = $oif[0];
@oif = ias::simpleXPath::simpleXPathQueryForText($xmlFile,'FederationConfig//Config[@name="idpglobal"]//Property[@name="sessionattributeforceauthn"]');
$forceAuth = $oif[0];

ias::asecm::printResult(
	$enableIdp, 'string',
	$providerId, 'string',
	$assertionValid, 'number',
	$reauthenticate, 'number',
	$sendSignAssert, 'string',
	$artifactTimeout, 'number',
	$enableCmnDomain, 'string',
	$cmnDomainUrl, 'string',
	$cmnDomainName, 'string',
	$cmnDmnCookieLife, 'number',
	$ssoMode, 'string',
	$ssoUserAttr, 'string',
	$ssoAttrValue, 'string',
	$forceAuth, 'string',
);