#!/usr/local/bin/perl
# 
# $Header: emll/sysman/admin/scripts/iam/oif/getOIFIdPSAML20AssertPropDetail.pl /main/2 2010/08/16 22:31:17 proxy Exp $
#
# getOIFIdPSAML20AssertPropDetail.pl
# 
# Copyright (c) 2010, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      getOIFIdPSAML20AssertPropDetail.pl - <one-line expansion of the name>
#
#    DESCRIPTION
#      This file reads configuration metric OIFIdPSAML20AssertionMetric for oracle_federation target
#
#    NOTES
#      Reads from file config.xml and picks out the required data for the configuration metric.
#
#    MODIFIED   (MM/DD/YY)
#    proxy       05/04/10 - Creation
# 

use strict;
use ias::simpleXPath;
use ias::asecm;
use File::Spec;
my $domainHome = $ARGV[0];
my $serverName = $ARGV[1];

my $xmlFile; 

my $xmlFile1 = File::Spec->catfile("$domainHome","server","$serverName","stage","OIF","11.1.1.1.0","OIF","configuration","config.xml");
my $xmlFile2 = File::Spec->catfile("$domainHome","config","fmwconfig","servers","$serverName","applications","OIF_11.1.1.2.0","configuration","config.xml");
my $xmlFile3 = File::Spec->catfile("$domainHome","config","fmwconfig","servers","$serverName","applications","OIF_11.1.1.3.0","configuration","config.xml");
if(-e $xmlFile1){
	$xmlFile = $xmlFile1;
}
elsif(-e $xmlFile2){
	$xmlFile = $xmlFile2;
}
elsif(-e $xmlFile3){
	$xmlFile = $xmlFile3;
}

my @oif;
my $temp;

my $enabledIdFormats="";
my $defaultIdFormat="";
my $getX500FromSession="";
my $getEmailFromSession="";
my $getWindowsFromSession="";
my $getKerberosFromSession="";
my $getUnspecifiedFromSession="";
my $getCustomFromSession="";
my $nameFormatX500="";
my $nameFormatEmail="";
my $nameFormatWindows="";
my $nameFormatKerberos="";
my $nameFormatUnspecified="";
my $nameFormatCustom="";
my $customNameIdFormat="";
my $forceConsentUrl="";
my $forceConsent="";
my $sendEncryptAssert="";
my $sendEncryptAttr="";
my $sendEncryptNameId="";
my $sendSignAssert="";

@oif=ias::simpleXPath::simpleXPathQueryForText($xmlFile, 'FederationConfig//Config[@name="idpsaml20"]//PropertiesList[@name="nameidformats"]/Property');
foreach $temp (@oif) {
	if($enabledIdFormats){
		$enabledIdFormats = $enabledIdFormats . " , " . $temp;
	}
	else{
		$enabledIdFormats = $temp;
	}
}

@oif = ias::simpleXPath::simpleXPathQueryForText($xmlFile,'FederationConfig//Config[@name="idpsaml20"]//Property[@name="defaultnameidformat"]');
$defaultIdFormat = $oif[0];
@oif = ias::simpleXPath::simpleXPathQueryForText($xmlFile,'FederationConfig//Config[@name="idpsaml20"]//Property[@name="nameformatx500fromsession"]');
$getX500FromSession = $oif[0];
@oif = ias::simpleXPath::simpleXPathQueryForText($xmlFile,'FederationConfig//Config[@name="idpsaml20"]//Property[@name="nameformatemailfromsession"]');
$getEmailFromSession = $oif[0];
@oif = ias::simpleXPath::simpleXPathQueryForText($xmlFile,'FederationConfig//Config[@name="idpsaml20"]//Property[@name="nameformatwindowsfromsession"]');
$getWindowsFromSession = $oif[0];
@oif = ias::simpleXPath::simpleXPathQueryForText($xmlFile,'FederationConfig//Config[@name="idpsaml20"]//Property[@name="nameformatkerberosfromsession"]');
$getKerberosFromSession = $oif[0];
@oif = ias::simpleXPath::simpleXPathQueryForText($xmlFile,'FederationConfig//Config[@name="idpsaml20"]//Property[@name="nameformatunspecifiedfromsession"]');
$getUnspecifiedFromSession = $oif[0];
@oif = ias::simpleXPath::simpleXPathQueryForText($xmlFile,'FederationConfig//Config[@name="idpsaml20"]//Property[@name="nameformatcustomfromsession"]');
$getCustomFromSession = $oif[0];
@oif = ias::simpleXPath::simpleXPathQueryForText($xmlFile,'FederationConfig//Config[@name="idpsaml20"]//Property[@name="nameformatx500"]');
$nameFormatX500 = $oif[0];
@oif = ias::simpleXPath::simpleXPathQueryForText($xmlFile,'FederationConfig//Config[@name="idpsaml20"]//Property[@name="nameformatemail"]');
$nameFormatEmail = $oif[0];
@oif = ias::simpleXPath::simpleXPathQueryForText($xmlFile,'FederationConfig//Config[@name="idpsaml20"]//Property[@name="nameformatwindows"]');
$nameFormatWindows = $oif[0];
@oif = ias::simpleXPath::simpleXPathQueryForText($xmlFile,'FederationConfig//Config[@name="idpsaml20"]//Property[@name="nameformatkerberos"]');
$nameFormatKerberos = $oif[0];
@oif = ias::simpleXPath::simpleXPathQueryForText($xmlFile,'FederationConfig//Config[@name="idpsaml20"]//Property[@name="nameformatunspecified"]');
$nameFormatUnspecified = $oif[0];
@oif = ias::simpleXPath::simpleXPathQueryForText($xmlFile,'FederationConfig//Config[@name="idpsaml20"]//Property[@name="nameformatcustom"]');
$nameFormatCustom = $oif[0];
@oif = ias::simpleXPath::simpleXPathQueryForText($xmlFile,'FederationConfig//Config[@name="idpsaml20"]//Property[@name="customnameidformat"]');
$customNameIdFormat = $oif[0];
@oif = ias::simpleXPath::simpleXPathQueryForText($xmlFile,'FederationConfig//Config[@name="idpsaml20"]//Property[@name="forceconsenturl"]');
$forceConsentUrl = $oif[0];
@oif = ias::simpleXPath::simpleXPathQueryForText($xmlFile,'FederationConfig//Config[@name="idpsaml20"]//Property[@name="forceconsent"]');
$forceConsent = $oif[0];
@oif = ias::simpleXPath::simpleXPathQueryForText($xmlFile,'FederationConfig//Config[@name="idpsaml20"]//Property[@name="sendencryptedassertion"]');
$sendEncryptAssert = $oif[0];
@oif = ias::simpleXPath::simpleXPathQueryForText($xmlFile,'FederationConfig//Config[@name="idpsaml20"]//Property[@name="sendencryptedattribute"]');
$sendEncryptAttr = $oif[0];
@oif = ias::simpleXPath::simpleXPathQueryForText($xmlFile,'FederationConfig//Config[@name="idpsaml20"]//Property[@name="sendencryptednameid"]');
$sendEncryptNameId = $oif[0];
@oif = ias::simpleXPath::simpleXPathQueryForText($xmlFile,'FederationConfig//Config[@name="idpsaml20"]//Property[@name="sendsignedassertion"]');
$sendSignAssert = $oif[0];

ias::asecm::printResult(
	$enabledIdFormats, 'string',
	$defaultIdFormat, 'string',
	$getX500FromSession, 'string',
	$getEmailFromSession, 'string',
	$getWindowsFromSession, 'string',
	$getKerberosFromSession, 'string',
	$getUnspecifiedFromSession, 'string',
	$getCustomFromSession, 'string',
	$nameFormatX500, 'string',
	$nameFormatEmail, 'string',
	$nameFormatWindows, 'string',
	$nameFormatKerberos, 'string',
	$nameFormatUnspecified, 'string',
	$nameFormatCustom, 'string',
	$customNameIdFormat, 'string',
	$forceConsentUrl, 'string',
	$forceConsent, 'string',
	$sendEncryptAssert, 'string',
	$sendEncryptAttr, 'string',
	$sendEncryptNameId, 'string',
	$sendSignAssert, 'string',
);