#!/usr/local/bin/perl
# 
# $Header: emll/sysman/admin/scripts/iam/oif/getOIFIdPSAML20ProtoPropDetail.pl /main/2 2010/08/16 22:31:17 proxy Exp $
#
# getOIFIdPSAML20ProtoPropDetail.pl
# 
# Copyright (c) 2010, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      getOIFIdPSAML20ProtoPropDetail.pl - <one-line expansion of the name>
#
#    DESCRIPTION
#      This file reads configuration metric OIFIdPSAML20ProtocolMetric for oracle_federation target
#
#    NOTES
#      Reads from file config.xml and picks out the required data for the configuration metric.
#
#    MODIFIED   (MM/DD/YY)
#    proxy       05/04/10 - Creation
# 

use strict;
use ias::simpleXPath;
use ias::asecm;
use File::Spec;
my $domainHome = $ARGV[0];
my $serverName = $ARGV[1];

my $xmlFile; 

my $xmlFile1 = File::Spec->catfile("$domainHome","server","$serverName","stage","OIF","11.1.1.1.0","OIF","configuration","config.xml");
my $xmlFile2 = File::Spec->catfile("$domainHome","config","fmwconfig","servers","$serverName","applications","OIF_11.1.1.2.0","configuration","config.xml");
my $xmlFile3 = File::Spec->catfile("$domainHome","config","fmwconfig","servers","$serverName","applications","OIF_11.1.1.3.0","configuration","config.xml");
if(-e $xmlFile1){
	$xmlFile = $xmlFile1;
}
elsif(-e $xmlFile2){
	$xmlFile = $xmlFile2;
}
elsif(-e $xmlFile3){
	$xmlFile = $xmlFile3;
}

my @oif;
my $temp;

my $saml20Enabled="";
my $rniEnabled="";
my $fedTermEnabled="";
my $attrResponderEnabled="";
my $attrResponderUseFed="";
my $authnResponderEnabled="";
my $assertIdResponderEnabled="";
my $enableProtocolBindings="";
my $defaultBinding="";
my $defaultSSOBinding="";
my $requireSignAuthnReq="";
my $requireSignReqPost="";
my $requireSignReqQuery="";
my $requireSignReqSoap="";
my $requireSignRespPost="";
my $requireSignRespQuery="";
my $requireSignRespSoap="";
my $sendSignReqPost="";
my $sendSignReqQuery="";
my $sendSignReqSoap="";
my $sendSignRespPost="";
my $sendSignRespQuery="";
my $sendSignRespSoap="";
my $sendSignRespAssertPost="";
my $sendSignRespAssertSoap="";

@oif = ias::simpleXPath::simpleXPathQueryForText($xmlFile,'FederationConfig//Config[@name="idpsaml20"]//Property[@name="saml20enabled"]');
$saml20Enabled = $oif[0];
@oif = ias::simpleXPath::simpleXPathQueryForText($xmlFile,'FederationConfig//Config[@name="idpsaml20"]//Property[@name="rnienabled"]');
$rniEnabled = $oif[0];
@oif = ias::simpleXPath::simpleXPathQueryForText($xmlFile,'FederationConfig//Config[@name="idpsaml20"]//Property[@name="fedtermenabled"]');
$fedTermEnabled = $oif[0];
@oif = ias::simpleXPath::simpleXPathQueryForText($xmlFile,'FederationConfig//Config[@name="idpsaml20"]//Property[@name="attributeresponderenabled"]');
$attrResponderEnabled = $oif[0];
@oif = ias::simpleXPath::simpleXPathQueryForText($xmlFile,'FederationConfig//Config[@name="idpsaml20"]//Property[@name="attributeresponderusefederation"]');
$attrResponderUseFed = $oif[0];
@oif = ias::simpleXPath::simpleXPathQueryForText($xmlFile,'FederationConfig//Config[@name="idpsaml20"]//Property[@name="authnresponderenabled"]');
$authnResponderEnabled = $oif[0];
@oif = ias::simpleXPath::simpleXPathQueryForText($xmlFile,'FederationConfig//Config[@name="idpsaml20"]//Property[@name="assertionidresponderenabled"]');
$assertIdResponderEnabled = $oif[0];

@oif=ias::simpleXPath::simpleXPathQueryForText($xmlFile, 'FederationConfig//Config[@name="idpsaml20"]//PropertiesList[@name="ssobindings"]/Property');
foreach $temp (@oif) {
	if($enableProtocolBindings){
		$enableProtocolBindings = $enableProtocolBindings . " , " . $temp;
	}
	else{
		$enableProtocolBindings = $temp;
	}
}
@oif=ias::simpleXPath::simpleXPathQueryForText($xmlFile, 'FederationConfig//Config[@name="idpsaml20"]//PropertiesList[@name="authnreqbindings"]/Property');
foreach $temp (@oif) {
	if($enableProtocolBindings){
		$enableProtocolBindings = $enableProtocolBindings . " , " . $temp;
	}
	else{
		$enableProtocolBindings = $temp;
	}
}
@oif=ias::simpleXPath::simpleXPathQueryForText($xmlFile, 'FederationConfig//Config[@name="idpsaml20"]//PropertiesList[@name="slobindings"]/Property');
foreach $temp (@oif) {
	if($enableProtocolBindings){
		$enableProtocolBindings = $enableProtocolBindings . " , " . $temp;
	}
	else{
		$enableProtocolBindings = $temp;
	}
}
@oif=ias::simpleXPath::simpleXPathQueryForText($xmlFile, 'FederationConfig//Config[@name="idpsaml20"]//PropertiesList[@name="mnibindings"]/Property');
foreach $temp (@oif) {
	if($enableProtocolBindings){
		$enableProtocolBindings = $enableProtocolBindings . " , " . $temp;
	}
	else{
		$enableProtocolBindings = $temp;
	}
}

@oif = ias::simpleXPath::simpleXPathQueryForText($xmlFile,'FederationConfig//Config[@name="idpsaml20"]//Property[@name="defaultbinding"]');
$defaultBinding = $oif[0];
@oif = ias::simpleXPath::simpleXPathQueryForText($xmlFile,'FederationConfig//Config[@name="idpsaml20"]//Property[@name="defaultssoresponsebinding"]');
$defaultSSOBinding = $oif[0];
@oif = ias::simpleXPath::simpleXPathQueryForText($xmlFile,'FederationConfig//Config[@name="idpsaml20"]//Property[@name="requiresignedauthnrequest"]');
$requireSignAuthnReq = $oif[0];
@oif = ias::simpleXPath::simpleXPathQueryForText($xmlFile,'FederationConfig//Config[@name="idpsaml20"]//Property[@name="requiresignedrequestpost"]');
$requireSignReqPost = $oif[0];
@oif = ias::simpleXPath::simpleXPathQueryForText($xmlFile,'FederationConfig//Config[@name="idpsaml20"]//Property[@name="requiresignedrequestquery"]');
$requireSignReqQuery = $oif[0];
@oif = ias::simpleXPath::simpleXPathQueryForText($xmlFile,'FederationConfig//Config[@name="idpsaml20"]//Property[@name="requiresignedrequestsoap"]');
$requireSignReqSoap = $oif[0];
@oif = ias::simpleXPath::simpleXPathQueryForText($xmlFile,'FederationConfig//Config[@name="idpsaml20"]//Property[@name="requiresignedresponsepost"]');
$requireSignRespPost = $oif[0];
@oif = ias::simpleXPath::simpleXPathQueryForText($xmlFile,'FederationConfig//Config[@name="idpsaml20"]//Property[@name="requiresignedresponsequery"]');
$requireSignRespQuery = $oif[0];
@oif = ias::simpleXPath::simpleXPathQueryForText($xmlFile,'FederationConfig//Config[@name="idpsaml20"]//Property[@name="requiresignedresponsesoap"]');
$requireSignRespSoap = $oif[0];
@oif = ias::simpleXPath::simpleXPathQueryForText($xmlFile,'FederationConfig//Config[@name="idpsaml20"]//Property[@name="sendsignedrequestpost"]');
$sendSignReqPost = $oif[0];
@oif = ias::simpleXPath::simpleXPathQueryForText($xmlFile,'FederationConfig//Config[@name="idpsaml20"]//Property[@name="sendsignedrequestquery"]');
$sendSignReqQuery = $oif[0];
@oif = ias::simpleXPath::simpleXPathQueryForText($xmlFile,'FederationConfig//Config[@name="idpsaml20"]//Property[@name="sendsignedrequestsoap"]');
$sendSignReqSoap = $oif[0];
@oif = ias::simpleXPath::simpleXPathQueryForText($xmlFile,'FederationConfig//Config[@name="idpsaml20"]//Property[@name="sendsignedresponsepost"]');
$sendSignRespPost = $oif[0];
@oif = ias::simpleXPath::simpleXPathQueryForText($xmlFile,'FederationConfig//Config[@name="idpsaml20"]//Property[@name="sendsignedresponsequery"]');
$sendSignRespQuery = $oif[0];
@oif = ias::simpleXPath::simpleXPathQueryForText($xmlFile,'FederationConfig//Config[@name="idpsaml20"]//Property[@name="sendsignedresponsesoap"]');
$sendSignRespSoap = $oif[0];
@oif = ias::simpleXPath::simpleXPathQueryForText($xmlFile,'FederationConfig//Config[@name="idpsaml20"]//Property[@name="sendsignedresponseassertionpost"]');
$sendSignRespAssertPost = $oif[0];
@oif = ias::simpleXPath::simpleXPathQueryForText($xmlFile,'FederationConfig//Config[@name="idpsaml20"]//Property[@name="sendsignedresponseassertionsoap"]');
$sendSignRespAssertSoap = $oif[0];

ias::asecm::printResult(
	$saml20Enabled, 'string',
	$rniEnabled, 'string',
	$fedTermEnabled, 'string',
	$attrResponderEnabled, 'string',
	$attrResponderUseFed, 'string',
	$authnResponderEnabled, 'string',
	$assertIdResponderEnabled, 'string',
	$enableProtocolBindings, 'string',
	$defaultBinding, 'string',
	$defaultSSOBinding, 'string',
	$requireSignAuthnReq, 'string',
	$requireSignReqPost, 'string',
	$requireSignReqQuery, 'string',
	$requireSignReqSoap, 'string',
	$requireSignRespPost, 'string',
	$requireSignRespQuery, 'string',
	$requireSignRespSoap, 'string',
	$sendSignReqPost, 'string',
	$sendSignReqQuery, 'string',
	$sendSignReqSoap, 'string',
	$sendSignRespPost, 'string',
	$sendSignRespQuery, 'string',
	$sendSignRespSoap, 'string',
	$sendSignRespAssertPost, 'string',
	$sendSignRespAssertSoap, 'string',
);
