#!/usr/local/bin/perl
# 
# $Header: emll/sysman/admin/scripts/iam/oif/getOIFIdPWSFed11PropertyDetail.pl /main/2 2010/08/16 22:31:17 proxy Exp $
#
# getOIFIdPWSFed11PropertyDetail.pl
# 
# Copyright (c) 2010, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      getOIFIdPWSFed11PropertyDetail.pl - <one-line expansion of the name>
#
#    DESCRIPTION
#      This file reads configuration metric OIFIdPWSFed11PopertyMetric for oracle_federation target
#
#    NOTES
#      Reads from file config.xml and picks out the required data for the configuration metric.
#
#    MODIFIED   (MM/DD/YY)
#    proxy       05/04/10 - Creation
# 

use strict;
use ias::simpleXPath;
use ias::asecm;
use File::Spec;
my $domainHome = $ARGV[0];
my $serverName = $ARGV[1];

my $xmlFile; 

my $xmlFile1 = File::Spec->catfile("$domainHome","server","$serverName","stage","OIF","11.1.1.1.0","OIF","configuration","config.xml");
my $xmlFile2 = File::Spec->catfile("$domainHome","config","fmwconfig","servers","$serverName","applications","OIF_11.1.1.2.0","configuration","config.xml");
my $xmlFile3 = File::Spec->catfile("$domainHome","config","fmwconfig","servers","$serverName","applications","OIF_11.1.1.3.0","configuration","config.xml");
if(-e $xmlFile1){
	$xmlFile = $xmlFile1;
}
elsif(-e $xmlFile2){
	$xmlFile = $xmlFile2;
}
elsif(-e $xmlFile3){
	$xmlFile = $xmlFile3;
}

my @oif;

my $enableWSFed="";
my $ssoTokenType="";
my $wsFedAssertGen="";

@oif = ias::simpleXPath::simpleXPathQueryForText($xmlFile,'FederationConfig//Config[@name="idpwsfed11"]//Property[@name="wsfed11enabled"]');
my $enableWSFed = $oif[0];
@oif = ias::simpleXPath::simpleXPathQueryForText($xmlFile,'FederationConfig//Config[@name="idpwsfed11"]//Property[@name="wsfedsamlassertionversion"]');
my $ssoTokenType = $oif[0];
@oif = ias::simpleXPath::simpleXPathQueryForText($xmlFile,'FederationConfig//Config[@name="idpwsfed11"]//Property[@name="wsfedadfsmodeenabled"]');
my $wsFedAssertGen = $oif[0];

ias::asecm::printResult(
	$enableWSFed, 'string',
	$ssoTokenType, 'string',
	$wsFedAssertGen, 'string',
);