#!/usr/local/bin/perl
# 
# $Header: emll/sysman/admin/scripts/iam/oif/getOIFSPConfigDetail.pl /main/2 2010/08/16 22:31:17 proxy Exp $
#
# getOIFSPConfigDetail.pl
# 
# Copyright (c) 2010, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      getOIFSPConfigDetail.pl - <one-line expansion of the name>
#
#    DESCRIPTION
#      This file reads configuration metric OIFSPConfigMetric for oracle_federation target
#
#    NOTES
#      Reads from file config.xml and picks out the required data for the configuration metric.
#
#    MODIFIED   (MM/DD/YY)
#    proxy       05/04/10 - Creation
# 

use strict;
use ias::simpleXPath;
use ias::asecm;
use File::Spec;
my $domainHome = $ARGV[0];
my $serverName = $ARGV[1];

my $xmlFile; 

my $xmlFile1 = File::Spec->catfile("$domainHome","server","$serverName","stage","OIF","11.1.1.1.0","OIF","configuration","config.xml");
my $xmlFile2 = File::Spec->catfile("$domainHome","config","fmwconfig","servers","$serverName","applications","OIF_11.1.1.2.0","configuration","config.xml");
my $xmlFile3 = File::Spec->catfile("$domainHome","config","fmwconfig","servers","$serverName","applications","OIF_11.1.1.3.0","configuration","config.xml");
if(-e $xmlFile1){
	$xmlFile = $xmlFile1;
}
elsif(-e $xmlFile2){
	$xmlFile = $xmlFile2;
}
elsif(-e $xmlFile3){
	$xmlFile = $xmlFile3;
}

my @oif;
my @dns;
my $dn="";
my @idps;
my $idp="";
my @authmech;

my $spEnabled="";
my $providerId="";
my $ssoAssertUsrMap="";
my $anonyUsrId="";
my $ignoreUnknownCond="";
my $reqSignedAssert="";
my $defaultSsoIdp="";
my $idpDiscSrvcEnabled="";
my $idpDiscSrvcUrl="";
my $cmnDomainEnabled="";
my $cmnDomainUrl="";
my $attrRequesterEnabled="";
my $defaultAttrAuth="";
my $dnIdpMap="";
my $authMechIdpMap="";

@oif = ias::simpleXPath::simpleXPathQueryForText($xmlFile,'FederationConfig//Config[@name="spglobal"]//Property[@name="spenabled"]');
$spEnabled = $oif[0];
@oif = ias::simpleXPath::simpleXPathQueryForText($xmlFile,'FederationConfig//Config[@name="spglobal"]//Property[@name="providerid"]');
$providerId = $oif[0];
@oif = ias::simpleXPath::simpleXPathQueryForText($xmlFile,'FederationConfig//Config[@name="spglobal"]//Property[@name="ssoassertionusermapping"]');
$ssoAssertUsrMap = $oif[0];
@oif = ias::simpleXPath::simpleXPathQueryForText($xmlFile,'FederationConfig//Config[@name="spglobal"]//Property[@name="anonymoususerid"]');
$anonyUsrId = $oif[0];
@oif = ias::simpleXPath::simpleXPathQueryForText($xmlFile,'FederationConfig//Config[@name="spglobal"]//Property[@name="ignoreunknownconditions"]');
$ignoreUnknownCond = $oif[0];
@oif = ias::simpleXPath::simpleXPathQueryForText($xmlFile,'FederationConfig//Config[@name="spglobal"]//Property[@name="requiresignedassertion"]');
$reqSignedAssert = $oif[0];
@oif = ias::simpleXPath::simpleXPathQueryForText($xmlFile,'FederationConfig//Config[@name="spglobal"]//Property[@name="defaultssoidp"]');
$defaultSsoIdp = $oif[0];
@oif = ias::simpleXPath::simpleXPathQueryForText($xmlFile,'FederationConfig//Config[@name="spglobal"]//Property[@name="idpdiscoveryserviceenabled"]');
$idpDiscSrvcEnabled = $oif[0];
@oif = ias::simpleXPath::simpleXPathQueryForText($xmlFile,'FederationConfig//Config[@name="spglobal"]//Property[@name="idpdiscoveryserviceurl"]');
$idpDiscSrvcUrl = $oif[0];
@oif = ias::simpleXPath::simpleXPathQueryForText($xmlFile,'FederationConfig//Config[@name="spglobal"]//Property[@name="commondomainenabled"]');
$cmnDomainEnabled = $oif[0];
@oif = ias::simpleXPath::simpleXPathQueryForText($xmlFile,'FederationConfig//Config[@name="spglobal"]//Property[@name="commondomainurl"]');
$cmnDomainUrl = $oif[0];
@oif = ias::simpleXPath::simpleXPathQueryForText($xmlFile,'FederationConfig//Config[@name="spglobal"]//Property[@name="attributerequesterenabled"]');
$attrRequesterEnabled = $oif[0];
@oif = ias::simpleXPath::simpleXPathQueryForText($xmlFile,'FederationConfig//Config[@name="dnidpmapping"]//Property[@name="defaultattrauthority"]');
$defaultAttrAuth = $oif[0];

@dns = ias::simpleXPath::simpleXPathQueryForText($xmlFile,'FederationConfig//Config[@name="dnidpmapping"]//PropertiesList[@name="dns"]/Property');
foreach $dn (@dns) {
	@idps = ias::simpleXPath::simpleXPathQueryForText($xmlFile,'FederationConfig//Config[@name="dnidpmapping"]//Property[@name="' . $dn . '"]');
	$idp = $idps[0];
	if($dnIdpMap){
		$dnIdpMap = $dnIdpMap . " ; " . $dn . " : " . $idp;
	}
	else{
		$dnIdpMap = $dn . " : " . $idp;
	}
}

@oif = ias::simpleXPath::simpleXPathQueryForText($xmlFile,'FederationConfig//Config[@name="spglobal"]//PropertiesList[@name="authnmechssomappingmech"]');
@authmech = split(/\s+/,$oif[0]);
@oif = ias::simpleXPath::simpleXPathQueryForText($xmlFile,'FederationConfig//Config[@name="spglobal"]//PropertiesList[@name="authnmechssomappingidp"]');
@idps = split(/\s+/,$oif[0]);

my $size = @idps;
my $i;
for ($i=1; $i<$size ; $i++) {
	if($idps[$i] ne "defaultssoidp"){
		if($authMechIdpMap){
			$authMechIdpMap = $authMechIdpMap . " ; " . $authmech[$i] . " : " . $idps[$i];
		}
		else{
			$authMechIdpMap = $authmech[$i] . " : " . $idps[$i];
		}
	}
}

ias::asecm::printResult(
	$spEnabled, 'string',
	$providerId, 'string',
	$ssoAssertUsrMap, 'string',
	$anonyUsrId, 'string',
	$ignoreUnknownCond, 'string',
	$reqSignedAssert, 'string',
	$defaultSsoIdp, 'string',
	$idpDiscSrvcEnabled, 'string',
	$idpDiscSrvcUrl, 'string',
	$cmnDomainEnabled, 'string',
	$cmnDomainUrl, 'string',
	$attrRequesterEnabled, 'string',
	$defaultAttrAuth, 'string',
	$dnIdpMap, 'string',
	$authMechIdpMap, 'string',
);