#!/usr/local/bin/perl
# 
# $Header: emll/sysman/admin/scripts/iam/oif/getOIFSPSAML20AssertPropDetail.pl /main/2 2010/08/16 22:31:17 proxy Exp $
#
# getOIFSPSAML20AssertPropDetail.pl
# 
# Copyright (c) 2010, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      getOIFSPSAML20AssertPropDetail.pl - <one-line expansion of the name>
#
#    DESCRIPTION
#      This file reads configuration metric OIFSPSAML20AssertionMetric for oracle_federation target
#
#    NOTES
#      Reads from file config.xml and picks out the required data for the configuration metric.
#
#    MODIFIED   (MM/DD/YY)
#    proxy       05/04/10 - Creation
# 

use strict;
use ias::simpleXPath;
use ias::asecm;
use File::Spec;
my $domainHome = $ARGV[0];
my $serverName = $ARGV[1];

my $xmlFile; 

my $xmlFile1 = File::Spec->catfile("$domainHome","server","$serverName","stage","OIF","11.1.1.1.0","OIF","configuration","config.xml");
my $xmlFile2 = File::Spec->catfile("$domainHome","config","fmwconfig","servers","$serverName","applications","OIF_11.1.1.2.0","configuration","config.xml");
my $xmlFile3 = File::Spec->catfile("$domainHome","config","fmwconfig","servers","$serverName","applications","OIF_11.1.1.3.0","configuration","config.xml");
if(-e $xmlFile1){
	$xmlFile = $xmlFile1;
}
elsif(-e $xmlFile2){
	$xmlFile = $xmlFile2;
}
elsif(-e $xmlFile3){
	$xmlFile = $xmlFile3;
}

my @oif;
my $temp;

my $ssoAttrBaseAuthn="";
my $autoAccLinkEnabled="";
my $ssoUsrMapAttr="";
my $ssoAttrMapQuery="";
my $ssoUsrMapNameId="";
my $enabledIdFormats="";
my $nameFormatX500="";
my $nameFormatEmail="";
my $nameFormatWindows="";
my $nameFormatKerberos="";
my $nameFormatUnspecified="";
my $nameFormatCustom="";
my $customNameIdFormat="";
my $attrBasedAuthnFailure="";
my $ignoreUnknownCond="";
my $requireSignAssert="";

@oif = ias::simpleXPath::simpleXPathQueryForText($xmlFile,'FederationConfig//Config[@name="spsaml20"]//Property[@name="ssoattributebasedauthn"]');
$ssoAttrBaseAuthn = $oif[0];
@oif = ias::simpleXPath::simpleXPathQueryForText($xmlFile,'FederationConfig//Config[@name="spsaml20"]//Property[@name="autoaccountlinkingenabled"]');
$autoAccLinkEnabled = $oif[0];
@oif = ias::simpleXPath::simpleXPathQueryForText($xmlFile,'FederationConfig//Config[@name="spsaml20"]//Property[@name="ssousermappingattr"]');
$ssoUsrMapAttr = $oif[0];
@oif = ias::simpleXPath::simpleXPathQueryForText($xmlFile,'FederationConfig//Config[@name="spsaml20"]//Property[@name="ssoattributemappingquery"]');
$ssoAttrMapQuery = $oif[0];
@oif = ias::simpleXPath::simpleXPathQueryForText($xmlFile,'FederationConfig//Config[@name="spsaml20"]//Property[@name="ssousermappingnameid"]');
$ssoUsrMapNameId = $oif[0];

@oif=ias::simpleXPath::simpleXPathQueryForText($xmlFile, 'FederationConfig//Config[@name="spsaml20"]//PropertiesList[@name="nameidformats"]/Property');
foreach $temp (@oif) {
	if($enabledIdFormats){
		$enabledIdFormats = $enabledIdFormats . " , " . $temp;
	}
	else{
		$enabledIdFormats = $temp;
	}
}

@oif = ias::simpleXPath::simpleXPathQueryForText($xmlFile,'FederationConfig//Config[@name="spsaml20"]//Property[@name="nameformatx500"]');
$nameFormatX500 = $oif[0];
@oif = ias::simpleXPath::simpleXPathQueryForText($xmlFile,'FederationConfig//Config[@name="spsaml20"]//Property[@name="nameformatemail"]');
$nameFormatEmail = $oif[0];
@oif = ias::simpleXPath::simpleXPathQueryForText($xmlFile,'FederationConfig//Config[@name="spsaml20"]//Property[@name="nameformatwindows"]');
$nameFormatWindows = $oif[0];
@oif = ias::simpleXPath::simpleXPathQueryForText($xmlFile,'FederationConfig//Config[@name="spsaml20"]//Property[@name="nameformatkerberos"]');
$nameFormatKerberos = $oif[0];
@oif = ias::simpleXPath::simpleXPathQueryForText($xmlFile,'FederationConfig//Config[@name="spsaml20"]//Property[@name="nameformatunspecified"]');
$nameFormatUnspecified = $oif[0];
@oif = ias::simpleXPath::simpleXPathQueryForText($xmlFile,'FederationConfig//Config[@name="spsaml20"]//Property[@name="nameformatcustom"]');
$nameFormatCustom = $oif[0];
@oif = ias::simpleXPath::simpleXPathQueryForText($xmlFile,'FederationConfig//Config[@name="spsaml20"]//Property[@name="customnameidformat"]');
$customNameIdFormat = $oif[0];
@oif = ias::simpleXPath::simpleXPathQueryForText($xmlFile,'FederationConfig//Config[@name="spsaml20"]//Property[@name="ssoattributebasedauthnfailure"]');
$attrBasedAuthnFailure = $oif[0];
@oif = ias::simpleXPath::simpleXPathQueryForText($xmlFile,'FederationConfig//Config[@name="spsaml20"]//Property[@name="ignoreunknownconditions"]');
my $num = @oif;
if($num == 0){
	@oif = ias::simpleXPath::simpleXPathQueryForText($xmlFile,'FederationConfig//Config[@name="spglobal"]//Property[@name="ignoreunknownconditions"]');
}
$ignoreUnknownCond = $oif[0];
@oif = ias::simpleXPath::simpleXPathQueryForText($xmlFile,'FederationConfig//Config[@name="spsaml20"]//Property[@name="requiresignedassertion"]');
$requireSignAssert = $oif[0];

ias::asecm::printResult(
	$ssoAttrBaseAuthn, 'string',
	$autoAccLinkEnabled, 'string',
	$ssoUsrMapAttr, 'string',
	$ssoAttrMapQuery, 'string',
	$ssoUsrMapNameId, 'string',
	$enabledIdFormats, 'string',
	$nameFormatX500, 'string',
	$nameFormatEmail, 'string',
	$nameFormatWindows, 'string',
	$nameFormatKerberos, 'string',
	$nameFormatUnspecified, 'string',
	$nameFormatCustom, 'string',
	$customNameIdFormat, 'string',
	$attrBasedAuthnFailure, 'string',
	$ignoreUnknownCond, 'string',
	$requireSignAssert, 'string',
);