#!/usr/local/bin/perl
# 
# $Header: emll/sysman/admin/scripts/iam/oif/getOIFServerConfigDetail.pl /main/2 2010/08/16 22:31:17 proxy Exp $
#
# getOIFServerConfigDetail.pl
# 
# Copyright (c) 2010, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      getOIFServerConfigDetail.pl - <one-line expansion of the name>
#
#    DESCRIPTION
#      This file reads configuration metric OIFServerConfigMetric for oracle_federation target
#
#    NOTES
#      Reads from file config.xml and picks out the required data for the configuration metric.
#
#    MODIFIED   (MM/DD/YY)
#    proxy       05/04/10 - Creation
# 

use strict;
use ias::simpleXPath;
use ias::asecm;
use File::Spec;
my $domainHome = $ARGV[0];
my $serverName = $ARGV[1];

my $xmlFile; 

my $xmlFile1 = File::Spec->catfile("$domainHome","server","$serverName","stage","OIF","11.1.1.1.0","OIF","configuration","config.xml");
my $xmlFile2 = File::Spec->catfile("$domainHome","config","fmwconfig","servers","$serverName","applications","OIF_11.1.1.2.0","configuration","config.xml");
my $xmlFile3 = File::Spec->catfile("$domainHome","config","fmwconfig","servers","$serverName","applications","OIF_11.1.1.3.0","configuration","config.xml");
if(-e $xmlFile1){
	$xmlFile = $xmlFile1;
}
elsif(-e $xmlFile2){
	$xmlFile = $xmlFile2;
}
elsif(-e $xmlFile3){
	$xmlFile = $xmlFile3;
}

my @oif;

my $svrHostName="";
my $srvPort="";
my $sslEnabled="";
my $forceSSL="";
my $soapPort="";
my $soapSSLEnabled="";
my $soapForceSSL="";
my $soapReqClientCert="";
my $svrClockDrift="";
my $sessionTimeout="";
my $requestTimeout="";
my $defaultEncrptMethod="";
my $loFailonError="";
my $loReturnStatus="";
my $loLocalOnly="";
my $loParallel="";
my $maxConn="";
my $maxConnPerSvr="";
my $proxyHost="";
my $proxyPort="";
my $proxyUsername="";
my $nonProxyHosts="";

@oif = ias::simpleXPath::simpleXPathQueryForText($xmlFile,'FederationConfig//Config[@name="serverconfig"]//Property[@name="hostname"]');
$svrHostName = $oif[0];
@oif = ias::simpleXPath::simpleXPathQueryForText($xmlFile,'FederationConfig//Config[@name="serverconfig"]//Property[@name="port"]');
$srvPort = $oif[0];
@oif = ias::simpleXPath::simpleXPathQueryForText($xmlFile,'FederationConfig//Config[@name="serverconfig"]//Property[@name="sslenabled"]');
$sslEnabled = $oif[0];
@oif = ias::simpleXPath::simpleXPathQueryForText($xmlFile,'FederationConfig//Config[@name="serverconfig"]//Property[@name="forcessl"]');
$forceSSL = $oif[0];
@oif = ias::simpleXPath::simpleXPathQueryForText($xmlFile,'FederationConfig//Config[@name="serverconfig"]//Property[@name="soapport"]');
$soapPort = $oif[0];
@oif = ias::simpleXPath::simpleXPathQueryForText($xmlFile,'FederationConfig//Config[@name="serverconfig"]//Property[@name="soapsslenabled"]');
$soapSSLEnabled = $oif[0];
@oif = ias::simpleXPath::simpleXPathQueryForText($xmlFile,'FederationConfig//Config[@name="serverconfig"]//Property[@name="soapforcessl"]');
$soapForceSSL = $oif[0];
@oif = ias::simpleXPath::simpleXPathQueryForText($xmlFile,'FederationConfig//Config[@name="serverconfig"]//Property[@name="soaprequiresslcert"]');
$soapReqClientCert = $oif[0];
@oif = ias::simpleXPath::simpleXPathQueryForText($xmlFile,'FederationConfig//Config[@name="serverconfig"]//Property[@name="serverclockdrift"]');
$svrClockDrift = $oif[0];
@oif = ias::simpleXPath::simpleXPathQueryForText($xmlFile,'FederationConfig//Config[@name="serverconfig"]//Property[@name="sessiontimeout"]');
$sessionTimeout = $oif[0];
@oif = ias::simpleXPath::simpleXPathQueryForText($xmlFile,'FederationConfig//Config[@name="serverconfig"]//Property[@name="requesttimeout"]');
$requestTimeout = $oif[0];
@oif = ias::simpleXPath::simpleXPathQueryForText($xmlFile,'FederationConfig//Config[@name="serverconfig"]//Property[@name="defaultencryptionmethod"]');
my $num = index($oif[0],"#");
$defaultEncrptMethod = substr($oif[0],$num+1);
@oif = ias::simpleXPath::simpleXPathQueryForText($xmlFile,'FederationConfig//Config[@name="serverconfig"]//Property[@name="slofailonerror"]');
$loFailonError = $oif[0];
@oif = ias::simpleXPath::simpleXPathQueryForText($xmlFile,'FederationConfig//Config[@name="serverconfig"]//Property[@name="sloreturnstatus"]');
$loReturnStatus = $oif[0];
@oif = ias::simpleXPath::simpleXPathQueryForText($xmlFile,'FederationConfig//Config[@name="serverconfig"]//Property[@name="sloonlylocal"]');
$loLocalOnly = $oif[0];
@oif = ias::simpleXPath::simpleXPathQueryForText($xmlFile,'FederationConfig//Config[@name="serverconfig"]//Property[@name="sloparallel"]');
$loParallel = $oif[0];
@oif = ias::simpleXPath::simpleXPathQueryForText($xmlFile,'FederationConfig//Config[@name="serverconfig"]//Property[@name="soapmaxconnections"]');
$maxConn = $oif[0];
@oif = ias::simpleXPath::simpleXPathQueryForText($xmlFile,'FederationConfig//Config[@name="serverconfig"]//Property[@name="soapmaxconnectionsperhost"]');
$maxConnPerSvr = $oif[0];
@oif = ias::simpleXPath::simpleXPathQueryForText($xmlFile,'FederationConfig//Config[@name="serverconfig"]//Property[@name="proxyhost"]');
$proxyHost = $oif[0];
@oif = ias::simpleXPath::simpleXPathQueryForText($xmlFile,'FederationConfig//Config[@name="serverconfig"]//Property[@name="proxyport"]');
$proxyPort = $oif[0];
@oif = ias::simpleXPath::simpleXPathQueryForText($xmlFile,'FederationConfig//Config[@name="serverconfig"]//Property[@name="proxyuser"]');
$proxyUsername = $oif[0];
@oif = ias::simpleXPath::simpleXPathQueryForText($xmlFile,'FederationConfig//Config[@name="serverconfig"]//Property[@name="nonproxyhosts"]');
$nonProxyHosts = $oif[0];

ias::asecm::printResult(
	$svrHostName, 'string',
	$srvPort, 'string',
	$sslEnabled, 'string',
	$forceSSL, 'string',
	$soapPort, 'string',
	$soapSSLEnabled, 'string',
	$soapForceSSL, 'string',
	$soapReqClientCert, 'string',
	$svrClockDrift, 'number',
	$sessionTimeout, 'number',
	$requestTimeout, 'number',
	$defaultEncrptMethod, 'string',
	$loFailonError, 'string',
	$loReturnStatus, 'string',
	$loLocalOnly, 'string',
	$loParallel, 'string',
	$maxConn, 'number',
	$maxConnPerSvr, 'number',
	$proxyHost, 'string',
	$proxyPort, 'string',
	$proxyUsername, 'string',
	$nonProxyHosts, 'string',
);