#!/usr/local/bin/perl
# 
# $Header: emll/sysman/admin/scripts/iam/oracle_iam_assoc.pl /main/5 2012/10/03 15:57:41 fmorshed Exp $
#
# oracle_iam_assoc.pl
# 
# Copyright (c) 2010, 2012, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      oracle_iam_assoc.pl - <one-line expansion of the name>
#
#    DESCRIPTION
#      <short description of component this file declares/defines>
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    fmorshed    10/02/12 - Remove / as first character to query targets.xml
#    fmorshed    01/19/12 - In advent of central collector, change query of
#                targets.xml to account for the new hierarchy of tags.
#    proxy       08/06/10 - fix_bug_9979754
#    proxy       08/02/10 - XbranchMerge proxy_idmocm20 from main
#    proxy       05/23/10 - Creation
# 

use strict;
#
# relationship types are defined in ecmassoc.pm
#
use ecmAssoc;
use ias::simpleXPath;
use File::Spec;
use Config;

#******************************************
#     Global Variables
#*****************************************
my $result = ();

#Take in the target name of the IAM instance for which we resolve the association.
#This will be required in order to locate the correct IAM instance in case of multiple IAM instance being present.
my $targetName = $ARGV[0];

#
# as new relationships are exposed, add them here
#

my $configCCRHome = $ENV{CCR_CONFIG_HOME};
my $discoveredTargetsFile = File::Spec->catfile("$configCCRHome","config","default","targets.xml");

if(!-e $discoveredTargetsFile)
{
	EMD_PERL_DEBUG("Can't get the file...: $discoveredTargetsFile.....");
	exit;
}
parseTargetXml($discoveredTargetsFile);

sub parseTargetXml
{
	my $fileName = $_[0];
	my @iam_assoc_results="";
	my $configFile = ias::simpleXPath::parseFile("$fileName");
    my $ohQueryPrefix = 'TargetHomes/TargetHome[@LOCATION="' . $ENV{ORACLE_HOME} . '"]';
	
	#get all targets of type oracle_iam_instance
	my @nodes = ias::simpleXPath::queryForNodes($configFile, $ohQueryPrefix.'/Targets/Target[@TYPE="oracle_iam_instance"]');
	my $hashSize=scalar(@nodes);
	for (my $count = 0; $count < $hashSize; $count++) 
	{
		#select the one with the same name
		my $name = ias::simpleXPath::getAttribute($nodes[$count], "NAME");
		#EMD_PERL_DEBUG("Target Type: $type");
		if($name eq $targetName)
		{
			my @assocNodes = ias::simpleXPath::queryForNodes($nodes[$count], 'Target/AssocTargetInstance');
			my $aHash=scalar(@assocNodes);
			for(my $cnt = 0; $cnt < $aHash; $cnt++)
			{
				my $assocTargetType = ias::simpleXPath::getAttribute($assocNodes[$cnt], "ASSOC_TARGET_TYPE");
				my $assocTargetName = ias::simpleXPath::getAttribute($assocNodes[$cnt], "ASSOC_TARGET_NAME");
				if($assocTargetType eq "oracle_ias_farm")
				{
					push(@iam_assoc_results, "em_result=".$ecmAssoc::DEPENDS_ON."|".$assocTargetName."|".$ecmAssoc::ORACLE_IAS_FARM_TYPE."|\n");
				}
			}
		}
	}
	if(defined(@iam_assoc_results) && scalar(@iam_assoc_results)>0)
	{
		foreach $result (@iam_assoc_results)
		{
			print $result;
		}
	}
	else
	{
		EMD_PERL_DEBUG("No Associations found for IAM Instance: $targetName");
		exit;
	}
}
