#!/usr/local/bin/perl
# 
# $Header: emll/sysman/admin/scripts/iam/oracle_oid_assoc.pl /main/6 2012/10/03 15:57:41 fmorshed Exp $
#
# oracle_oid_assoc.pl
# 
# Copyright (c) 2010, 2012, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      oracle_oid_assoc.pl - <one-line expansion of the name>
#
#    DESCRIPTION
#      <short description of component this file declares/defines>
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    fmorshed    10/02/12 - Remove / as first character to query targets.xml
#    fmorshed    01/19/12 - In advent of central collector, change query of
#                targets.xml to account for the new hierarchy of tags.
#    proxy       03/27/11 - fix_associations remove associations with farm and iam instance
#    proxy       08/06/10 - fix_bug_9979754
#    proxy       08/02/10 - XbranchMerge proxy_idmocm20 from main
#    proxy       05/21/10 - Creation
# 

use strict;
#
# relationship types are defined in ecmassoc.pm
#
use ecmAssoc;
use ias::simpleXPath;
use File::Spec;
use Config;

#******************************************
#     Global Variables
#*****************************************
my $result = ();

#
# as new relationships are exposed, add them here
#

my $targetName = $ARGV[0];
my $server = $ARGV[1];
my $port = $ARGV[2];

my $configCCRHome = $ENV{CCR_CONFIG_HOME};
my $discoveredTargetsFile = File::Spec->catfile("$configCCRHome","config","default","targets.xml");

if(!-e $discoveredTargetsFile)
{
	EMD_PERL_DEBUG("Can't get the file...: $discoveredTargetsFile.....");
	exit;
}
parseTargetXml($discoveredTargetsFile);

sub parseTargetXml
{
	my $fileName = $_[0];
	my $db_result;
	my $rac_result;
	my $dbhost;
	my $dbport;
	my $service_name;
	my $connectDescriptor;
	my $domainName;
	my $machineName;
	my $adminPort;
	my $domainPresent = "FALSE";
	my @oid_assoc_results="";
	my $targetFound = "FALSE";

	my $configFile = ias::simpleXPath::parseFile("$fileName");
    my $ohQueryPrefix = 'TargetHomes/TargetHome[@LOCATION="' . $ENV{ORACLE_HOME} . '"]';

	#get all targets of type oracle_ldap
	my @nodes = ias::simpleXPath::queryForNodes($configFile, $ohQueryPrefix.'/Targets/Target[@TYPE="oracle_ldap"]');
	my $hashSize=scalar(@nodes);
	for (my $count = 0; $count < $hashSize && $targetFound eq "FALSE"; $count++) 
	{
		my $name = ias::simpleXPath::getAttribute($nodes[$count], "NAME");
		#select the one with the same name
		if($name eq $targetName)
		{
			#check whether it has same admin server and port
			my @pNodes = ias::simpleXPath::queryForNodes($nodes[$count], 'Target/Property[@NAME="MachineName"]');
			my $serverName = ias::simpleXPath::getAttribute($pNodes[0], "VALUE");
			@pNodes = ias::simpleXPath::queryForNodes($nodes[$count], 'Target/Property[@NAME="Port"]');
			my $serverPort = ias::simpleXPath::getAttribute($pNodes[0], "VALUE");

			#store the value of connectDescriptor
			@pNodes = ias::simpleXPath::queryForNodes($nodes[$count], 'Target/Property[@NAME="ConnectDescriptor"]');
			$connectDescriptor = ias::simpleXPath::getAttribute($pNodes[0], "VALUE");

			if($serverName eq $server && $serverPort eq $port)
			{
				$machineName = $serverName;
				$adminPort = $serverPort;
				$targetFound = "TRUE";

				#get Associated Farm, Domain
				#for Farm and domain store the name
				my @assocNodes = ias::simpleXPath::queryForNodes($nodes[$count], 'Target/AssocTargetInstance');
				my $aHash=scalar(@assocNodes);
				for(my $cnt = 0; $cnt < $aHash; $cnt++)
				{
					my $assocTargetType = ias::simpleXPath::getAttribute($assocNodes[$cnt], "ASSOC_TARGET_TYPE");
					my $assocTargetName = ias::simpleXPath::getAttribute($assocNodes[$cnt], "ASSOC_TARGET_NAME");
					if($assocTargetType eq "weblogic_domain")
					{
						$domainName = $assocTargetName;
					}
				}
			}
		}
	}
	
	#check if domain target is present
	if(defined $domainName)
	{
		my @domainNodes = ias::simpleXPath::queryForNodes($configFile, $ohQueryPrefix.'/Targets/Target[@TYPE="weblogic_domain"][@NAME="'.$domainName.'"]');
		my $hashDomains = scalar(@domainNodes);
		if($hashDomains > 0)
		{
			$domainPresent = "TRUE";
		}
	}

	#domain if present, make an entry with domain name as target name or else store it in target property
	if($domainPresent eq "TRUE" && defined $domainName)
	{
		push(@oid_assoc_results, "em_result=".$ecmAssoc::MEMBER_OF."|".$domainName."|".$ecmAssoc::WEBLOGIC_DOMAIN."|".$machineName.":".$adminPort.":".$domainName."\n");
	}
	elsif(defined $domainName)
	{
		push(@oid_assoc_results, "em_result=".$ecmAssoc::MEMBER_OF."||".$ecmAssoc::WEBLOGIC_DOMAIN."|".$machineName.":".$adminPort.":".$domainName."\n");
	}

	#parse the connector descriptor
	if ((($dbhost, $dbport, $service_name) = ($connectDescriptor =~ /\s*.*?HOST=(.*?)\)\(PORT=(.*?)\).*?SERVICE_NAME=(.*?)\).*?/)) != 0)
	{
	    $rac_result = $dbhost.":".$dbport.":".$service_name;
		$db_result = $dbhost.":".$service_name;
	}
	else
	{	
		print "em_error=Error collecting the Database Information\n";
	    exit 0;
	}	
	
	#first we need to determine if it it a DB instance or RAC
	#check if it is a DB instance
	my $db_index;
	if (($db_index = index ($connectDescriptor, "LOAD_BALANCE=")) == -1)
	{
		push(@oid_assoc_results,"em_result=".$ecmAssoc::CONNECTS_TO."||".$ecmAssoc::ORACLE_DATABASE_TYPE."|".$db_result."\n");
	}
	#it is is RAC, 
	else	
	{
		# we can return any DB instance for this RAC and LL can find out the actual host
	    push(@oid_assoc_results,"em_result=".$ecmAssoc::CONNECTS_TO."||".$ecmAssoc::RAC_DATABASE_TYPE."|".$rac_result."\n");    
	}
	
	if(defined(@oid_assoc_results) && scalar(@oid_assoc_results)>0)
	{
		foreach $result (@oid_assoc_results)
		{
			print $result;
		}
	}
	else
	{
		EMD_PERL_DEBUG("No Associations found for OID: $targetName");
		exit;
	}
}
