#!/usr/local/bin/perl
# 
# $Header: emll/sysman/admin/scripts/iam/oracle_oif_assoc.pl /main/6 2012/10/03 15:57:41 fmorshed Exp $
#
# oracle_oif_assoc.pl
# 
# Copyright (c) 2010, 2012, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      oracle_oif_assoc.pl - <one-line expansion of the name>
#
#    DESCRIPTION
#      <short description of component this file declares/defines>
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    fmorshed    10/02/12 - Remove / as first character to query targets.xml
#    fmorshed    01/19/12 - In advent of central collector, change query of
#                targets.xml to account for the new hierarchy of tags.
#    proxy       03/27/11 - fix_associations remove associations with farm, domain and iam instance
#    proxy       08/06/10 - fix_bug_9979754
#    proxy       08/02/10 - XbranchMerge proxy_idmocm20 from main
#    proxy       05/21/10 - Creation
# 

use strict;
#
# relationship types are defined in ecmassoc.pm
#
use ecmAssoc;
use ias::simpleXPath;
use File::Spec;
use Config;

#******************************************
#     Global Variables
#*****************************************
my $result = ();

#
# as new relationships are exposed, add them here
#

my $targetName = $ARGV[0];
my $server = $ARGV[1];
my $port = $ARGV[2];

my $oracleHome = $ENV{WL_HOME};
my $configCCRHome = $ENV{CCR_CONFIG_HOME};
my $discoveredTargetsFile = File::Spec->catfile("$configCCRHome","config","default","targets.xml");

if(!-e $discoveredTargetsFile)
{
	EMD_PERL_DEBUG("Can't get the file...: $discoveredTargetsFile.....");
	exit;
}
parseTargetXml($discoveredTargetsFile);

sub parseTargetXml
{
	my $fileName = $_[0];
	my @oif_assoc_results="";
	my $targetFound = "FALSE";

	my $configFile = ias::simpleXPath::parseFile("$fileName");
    my $ohQueryPrefix = 'TargetHomes/TargetHome[@LOCATION="' . $ENV{ORACLE_HOME} . '"]';

	#get all targets of type oracle_federation
	my @nodes = ias::simpleXPath::queryForNodes($configFile, $ohQueryPrefix.'/Targets/Target[@TYPE="oracle_federation"]');
	my $hashSize=scalar(@nodes);
	for (my $count = 0; $count < $hashSize && $targetFound eq "FALSE"; $count++) 
	{
		my $name = ias::simpleXPath::getAttribute($nodes[$count], "NAME");
		#select the one with the same name
		if($name eq $targetName)
		{
			#check whether it has same admin server and port
			my @pNodes = ias::simpleXPath::queryForNodes($nodes[$count], 'Target/Property[@NAME="MachineName"]');
			my $serverName = ias::simpleXPath::getAttribute($pNodes[0], "VALUE");
			@pNodes = ias::simpleXPath::queryForNodes($nodes[$count], 'Target/Property[@NAME="Port"]');
			my $serverPort = ias::simpleXPath::getAttribute($pNodes[0], "VALUE");

			if($serverName eq $server && $serverPort eq $port)
			{
				$targetFound = "TRUE";

				#get Associated Farm, Domain and server
				#for Farm and domain store the name and for server store the entry for j2eeserver 
				my @assocNodes = ias::simpleXPath::queryForNodes($nodes[$count], 'Target/AssocTargetInstance');
				my $aHash=scalar(@assocNodes);
				for(my $cnt = 0; $cnt < $aHash; $cnt++)
				{
					my $assocTargetType = ias::simpleXPath::getAttribute($assocNodes[$cnt], "ASSOC_TARGET_TYPE");
					my $assocTargetName = ias::simpleXPath::getAttribute($assocNodes[$cnt], "ASSOC_TARGET_NAME");
					my $assocName = ias::simpleXPath::getAttribute($assocNodes[$cnt],"ASSOCIATION_NAME");
					if($assocTargetType eq "weblogic_j2eeserver" && $assocName eq "managedServer")
					{
						push(@oif_assoc_results, "em_result=".$ecmAssoc::RUNS_ON."|".$assocTargetName."|".$ecmAssoc::ORACLE_WEBLOGIC_SERVER."|".$server.":".$oracleHome."\n");
					}
				}
			}
		}
	}

	if(defined(@oif_assoc_results) && scalar(@oif_assoc_results)>0)
	{
		foreach $result (@oif_assoc_results)
		{
			print $result;
		}
	}
	else
	{
		EMD_PERL_DEBUG("No Associations found for OIF: $targetName");
		exit;
	}
}
