#!/usr/local/bin/perl
# 
# $Header: emll/sysman/admin/scripts/iam/ovd/getOVDListenerDetail.pl /main/2 2010/08/16 22:31:17 proxy Exp $
#
# getOVDListenerDetail.pl
# 
# Copyright (c) 2010, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      getOVDListenerDetail.pl - <one-line expansion of the name>
#
#    DESCRIPTION
#      This file reads configuration metric OVDListenerConfigMetric for oracle_ovd target
#
#    NOTES
#      Reads from file listeners.os_xml and picks out the required data for the configuration metric.
#
#    MODIFIED   (MM/DD/YY)
#    proxy       05/05/10 - Creation
# 

use strict;
use ias::simpleXPath;
use ias::asecm;
use File::Spec;

my $oracleInstance = $ARGV[0];
my $targetName = $ARGV[1];
my $slash = '/';
my $indexOf = rindex($targetName,$slash);
my $displayName = substr($targetName,$indexOf+1);

my $xmlFile = File::Spec->catfile("$oracleInstance","config","OVD","$displayName","listeners.os_xml");

my @ovd;
my @ssl;
my @listeners;
my $listener;
my $temp;

my $lsnrName="";
my $lsnrType="";
my $lsnrVer="";
my $lsnrActive="";
my $lsnrHost="";
my $lsnrPort="";
my $threads="";
my $groupUrl="";
my $sslEnabled="";
my $sslAuthType="";
my $sslTrustStore="";
my $sslKeyStore="";
my $sslProtocols="";
my $sslCiphers="";

@listeners = ias::simpleXPath::simpleXPathQuery($xmlFile, 'listeners//admin');
for $listener (@listeners) {
	$lsnrType = "ADMIN";
	getAllValues($listener,"admin");
	printAllValues();
}

@listeners = ias::simpleXPath::simpleXPathQuery($xmlFile, 'listeners//ldap');
for $listener (@listeners) {
	$lsnrType = "LDAP";
	getAllValues($listener,"ldap");
	printAllValues();
}

@listeners = ias::simpleXPath::simpleXPathQuery($xmlFile, 'listeners//http');
for $listener (@listeners) {
	$lsnrType = "HTTP";
	getAllValues($listener,"http");
	printAllValues();

}

sub getAllValues{
	my $tempCiphers;
	my $lsnrTemp = $_[0];
	my $tagName = $_[1];
	$lsnrName = $$lsnrTemp{'id'};
	$lsnrVer = $$lsnrTemp{'version'};
	
	@ovd = ias::simpleXPath::simpleXPathQueryForText($xmlFile, 'listeners//' . $tagName . '[@id="' . $lsnrName . '"]/active');
	$lsnrActive = $ovd[0];

	@ovd = ias::simpleXPath::simpleXPathQueryForText($xmlFile, 'listeners//' . $tagName . '[@id="' . $lsnrName . '"]/host');
	$lsnrHost = $ovd[0];

	@ovd = ias::simpleXPath::simpleXPathQueryForText($xmlFile, 'listeners//' . $tagName . '[@id="' . $lsnrName . '"]/port');
	$lsnrPort = $ovd[0];

	@ovd = ias::simpleXPath::simpleXPathQueryForText($xmlFile, 'listeners//' . $tagName . '[@id="' . $lsnrName . '"]/threads');
	$threads = $ovd[0];

	@ovd = ias::simpleXPath::simpleXPathQueryForText($xmlFile, 'listeners//' . $tagName . '[@id="' . $lsnrName . '"]/groupUrl');
	$groupUrl = $ovd[0];

	@ssl = ias::simpleXPath::simpleXPathQuery($xmlFile, 'listeners//' . $tagName . '[@id="' . $lsnrName . '"]//ssl');
	for my $ssl (@ssl) {
		$sslEnabled = $$ssl{'enabled'};
		
		@ovd = ias::simpleXPath::simpleXPathQueryForText($xmlFile, 'listeners//' . $tagName . '[@id="' . $lsnrName . '"]/ssl/authType');
		$sslAuthType = $ovd[0];

		@ovd = ias::simpleXPath::simpleXPathQueryForText($xmlFile, 'listeners//' . $tagName . '[@id="' . $lsnrName . '"]/ssl/trustStore');
		$sslTrustStore = $ovd[0];

		@ovd = ias::simpleXPath::simpleXPathQueryForText($xmlFile, 'listeners//' . $tagName . '[@id="' . $lsnrName . '"]/ssl/keyStore');
		$sslKeyStore = $ovd[0];

		@ovd = ias::simpleXPath::simpleXPathQueryForText($xmlFile, 'listeners//' . $tagName . '[@id="' . $lsnrName . '"]/ssl/protocols');
		$sslProtocols = $ovd[0];

		@ovd = ias::simpleXPath::simpleXPathQueryForText($xmlFile, 'listeners//' . $tagName . '[@id="' . $lsnrName . '"]/ssl/cipherSuites/cipher');
		foreach $temp (@ovd) {
			if($tempCiphers){
				$tempCiphers = $tempCiphers . " , " . $temp;
			}
			else{
				$tempCiphers = $temp;
			}
		}
		$sslCiphers = $tempCiphers;
	}
}

sub printAllValues{
	ias::asecm::printResult(
		$lsnrName, 'string',
		$lsnrType, 'string',
		$lsnrVer, 'number',
		$lsnrActive, 'string',
		$lsnrHost, 'string',
		$lsnrPort, 'string',
		$threads, 'number',
		$groupUrl, 'string',
		$sslEnabled, 'string',
		$sslAuthType, 'string',
		$sslTrustStore, 'string',
		$sslKeyStore, 'string',
		$sslProtocols, 'string',
		$sslCiphers, 'string',
	);
}