#!/usr/local/bin/perl
# 
# $Header: emll/sysman/admin/scripts/iam/ovd/getOVDSchemaDetail.pl /main/2 2010/08/16 22:31:17 proxy Exp $
#
# getOVDSchemaDetail.pl
# 
# Copyright (c) 2010, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      getOVDSchemaDetail.pl - <one-line expansion of the name>
#
#    DESCRIPTION
#      This file reads configuration metric OVDSchemaLocations for oracle_ovd target
#
#    NOTES
#      Reads from file server.os_xml and picks out the required data for the configuration metric.
#
#    MODIFIED   (MM/DD/YY)
#    proxy       05/05/10 - Creation
# 

use strict;
use ias::simpleXPath;
use ias::asecm;
use File::Spec;

my $oracleInstance = $ARGV[0];
my $targetName = $ARGV[1];
my $slash = '/';
my $indexOf = rindex($targetName,$slash);
my $displayName = substr($targetName,$indexOf+1);

my $xmlFile = File::Spec->catfile("$oracleInstance","config","OVD","$displayName","server.os_xml");

my @locations;
@locations = ias::simpleXPath::simpleXPathQueryForText($xmlFile, 'server/schema/location');

my $location="";
foreach $location (@locations) {
	ias::asecm::printResult(
		$location, 'string',
	);
}