#!/usr/local/bin/perl
# 
# $Header: emll/sysman/admin/scripts/iam/ovd/getOVDSearchDetail.pl /main/2 2010/08/16 22:31:17 proxy Exp $
#
# getOVDSearchDetail.pl
# 
# Copyright (c) 2010, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      getOVDSearchDetail.pl - <one-line expansion of the name>
#
#    DESCRIPTION
#      This file reads configuration metric OVDSearchLimitMetric for oracle_ovd target
#
#    NOTES
#      Reads from file server.os_xml and picks out the required data for the configuration metric.
#
#    MODIFIED   (MM/DD/YY)
#    proxy       05/05/10 - Creation
# 

use strict;
use ias::simpleXPath;
use ias::asecm;
use File::Spec;

my $oracleInstance = $ARGV[0];
my $targetName = $ARGV[1];
my $slash = '/';
my $indexOf = rindex($targetName,$slash);
my $displayName = substr($targetName,$indexOf+1);

my $xmlFile = File::Spec->catfile("$oracleInstance","config","OVD","$displayName","server.os_xml");

my @ovd;
my $temp;
my $anonymousSearch="";
my $authenticatedSearch="";
my $persistentSearch="";

@ovd = ias::simpleXPath::simpleXPathQueryForText($xmlFile, 'server/searchLimit/anonymous');
$anonymousSearch = $ovd[0];

@ovd = ias::simpleXPath::simpleXPathQueryForText($xmlFile, 'server/searchLimit/authenticated');
$authenticatedSearch = $ovd[0];

@ovd = ias::simpleXPath::simpleXPathQueryForText($xmlFile, 'server/persistentSearch');
$persistentSearch = $ovd[0];

ias::asecm::printResult(
	$anonymousSearch, 'number',
	$authenticatedSearch, 'number',
	$persistentSearch, 'string',
);