#!/usr/local/bin/perl
# 
# $Header: emll/sysman/admin/scripts/iam/ovd/getOVDServerDetail.pl /main/2 2010/08/16 22:31:17 proxy Exp $
#
# getOVDServerDetail.pl
# 
# Copyright (c) 2010, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      getOVDServerDetail.pl - <one-line expansion of the name>
#
#    DESCRIPTION
#      This file reads configuration metric OVDServerConfigMetric for oracle_ovd target
#
#    NOTES
#      Reads from file server.os_xml and picks out the required data for the configuration metric.
#
#    MODIFIED   (MM/DD/YY)
#    proxy       05/05/10 - Creation
# 

use strict;
use ias::simpleXPath;
use ias::asecm;
use File::Spec;

my $oracleInstance = $ARGV[0];
my $targetName = $ARGV[1];
my $slash = '/';
my $indexOf = rindex($targetName,$slash);
my $displayName = substr($targetName,$indexOf+1);

my $xmlFile = File::Spec->catfile("$oracleInstance","config","OVD","$displayName","server.os_xml");

my @ovd;
my $temp;

my $quotaActive="";
if(ias::simpleXPath::simpleXPathQueryForText($xmlFile, 'server/quota[@active="true"]')){
	$quotaActive = "true";
}
elsif(ias::simpleXPath::simpleXPathQueryForText($xmlFile, 'server/quota[@active="false"]')){
	$quotaActive = "false";
}

my $exemptIP="";
@ovd = ias::simpleXPath::simpleXPathQueryForText($xmlFile, 'server/quota/exemptip/address');
foreach $temp (@ovd) {
	if($exemptIP){
		$exemptIP = $exemptIP . " , " . $temp;
	}
	else{
		$exemptIP = $temp;
	}
}

my $exemptSubject="";
@ovd = ias::simpleXPath::simpleXPathQueryForText($xmlFile, 'server/quota/exemptsubject/subject');
foreach $temp (@ovd) {
	if($exemptSubject){
		$exemptSubject = $exemptSubject . " , " . $temp;
	}
	else{
		$exemptSubject = $temp;
	}
}

my $ratePeriod="";
@ovd = ias::simpleXPath::simpleXPathQueryForText($xmlFile, 'server/quota/ratePeriod');
$ratePeriod = $ovd[0];

my $maxConnTimeout="";
@ovd = ias::simpleXPath::simpleXPathQueryForText($xmlFile, 'server/quota/max/inactiveConnectionTimeout');
$maxConnTimeout = $ovd[0];

my $maxOpsPerConn="";
@ovd = ias::simpleXPath::simpleXPathQueryForText($xmlFile, 'server/quota/max/opspercon');
$maxOpsPerConn = $ovd[0];

my $maxConns="";
@ovd = ias::simpleXPath::simpleXPathQueryForText($xmlFile, 'server/quota/max/connections');
$maxConns = $ovd[0];

my $maxConnPerSub="";
@ovd = ias::simpleXPath::simpleXPathQueryForText($xmlFile, 'server/quota/max/consPerSubject');
$maxConnPerSub = $ovd[0];

my $maxConnPerIP="";
@ovd = ias::simpleXPath::simpleXPathQueryForText($xmlFile, 'server/quota/max/consPerIp');
$maxConnPerIP = $ovd[0];

my $aclCheck="";
if(ias::simpleXPath::simpleXPathQueryForText($xmlFile, 'server/acls[@check="true"]')){
	$aclCheck = "true";
}
elsif(ias::simpleXPath::simpleXPathQueryForText($xmlFile, 'server/acls[@check="false"]')){
	$aclCheck = "false";
}

my $schemaCheck="";
if(ias::simpleXPath::simpleXPathQueryForText($xmlFile, 'server/schema[@check="true"]')){
	$schemaCheck = "true";
}
elsif(ias::simpleXPath::simpleXPathQueryForText($xmlFile, 'server/schema[@check="false"]')){
	$schemaCheck = "false";
}

ias::asecm::printResult(
	$quotaActive, 'string',
	$exemptIP, 'string',
	$exemptSubject, 'string',
	$ratePeriod, 'number',
	$maxConnTimeout, 'number',
	$maxOpsPerConn, 'number',
	$maxConns, 'number',
	$maxConnPerSub, 'number',
	$maxConnPerIP, 'number',
	$aclCheck, 'string',
	$schemaCheck, 'string',
);