#!/usr/local/bin/perl
# 
# $Header: emll/sysman/admin/scripts/ias/Apache_getGeneral.pl /main/2 2010/06/22 23:09:59 aghanti Exp $
#
# Apache_getGeneral.pl
# 
# Copyright (c) 2004, 2010, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      Apache_getGeneral.pl - Apache ECM integration: get general configuration
#                             information
#
#    DESCRIPTION
#      Command line utility called by the Agent to retrieve general configuration
#      information for Apache. Includes the document root and default port.
#
#      Implements the General metric defined in oracle_apache.xml.
#
#      Command-line arguments: <oracle home> <ohs instance id (AS11 onwards)>
#
#    NOTES
#
#    MODIFIED   (MM/DD/YY)
#    aghanti     06/17/10 - Consider OHS instance id for AS11
#    jsmoler     06/09/09 - grab fixes from 10.2.0.5 GC
#    jsmoler     07/14/06 - use parseApacheConf (bug 5224028)
#    jsmoler     05/19/05 - dynamically determine root conf file 
#    jsmoler     01/28/05 - apache -> Apache
#    jsmoler     12/16/04 - make protocol lowercase 
#    jsmoler     12/14/04 - get protocol, server name 
#    jsmoler     10/25/04 - remove defaults 
#    jsmoler     10/18/04 - use path type 
#    jsmoler     10/07/04 - add default values 
#    jsmoler     10/04/04 - jsmoler_ecm01
#    jsmoler     09/13/04 - Creation
# 

use strict;
use ias::Apache_confFileParser;
use ias::asecm;

my $oracleHome = $ARGV[0];
setOracleHome($oracleHome);

my $ohsId = "";
if (-e "$oracleHome/config/OPMN/opmn/opmn.xml")
{
  # AS11: OHS instance ID has been passed as an argument
  $ohsId = $ARGV[1];
  # Set ohsId in the ENV. It will be used by asecm::parseApacheConf() later
  $ENV{'CCR_OHS_ID'} = $ohsId;
}

my $hash = parseApacheConf();

printResult(
    peek($$hash{'DocumentRoot'}),    'path',
    peek($$hash{'Port'}),            'number',
    peek($$hash{'ServerName'}),      'string',
);
