#!/usr/local/bin/perl
# 
# $Header: emll/sysman/admin/scripts/ias/Apache_getPerformanceRelated.pl /main/2 2010/06/22 23:09:59 aghanti Exp $
#
# Apache_getPerformanceRelated.pl
# 
# Copyright (c) 2004, 2010, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      Apache_getPerformanceRelated.pl - Apache ECM integration: get performance
#                                        related configuration information
#
#    DESCRIPTION
#      Command-line utility called by the Agent to retrieve performance-related
#      configuration information for Apache.
#
#      Implements the PerformanceRelated metric defined in oracle_apache.xml.
#
#      Command-line arguments: <oracle home> <ohs instance id (AS11 onwards)>
#
#    NOTES
#
#    MODIFIED   (MM/DD/YY)
#    aghanti     06/17/10 - Consider OHS instance id for AS11
#    jsmoler     06/09/09 - grab fixes from 10.2.0.5 GC
#    jsmoler     07/14/06 - use parseApacheConf (bug 5224028)
#    jsmoler     05/19/05 - dynamically determine root conf file 
#    jsmoler     01/28/05 - apache -> Apache
#    jsmoler     12/02/04 - fix typo 
#    jsmoler     10/25/04 - remove defaults 
#    jsmoler     10/07/04 - add defaults
#    jsmoler     10/04/04 - jsmoler_ecm01
#    jsmoler     09/13/04 - Creation
# 

use strict;
use ias::Apache_confFileParser;
use ias::asecm;

my $oracleHome = $ARGV[0];
setOracleHome($oracleHome);

my $ohsId = "";
if (-e "$oracleHome/config/OPMN/opmn/opmn.xml")
{
  # AS11: OHS instance ID has been passed as an argument
  $ohsId = $ARGV[1];
  # Set ohsId in the ENV. It will be used by asecm::parseApacheConf() later
  $ENV{'CCR_OHS_ID'} = $ohsId;
}

my $hash = parseApacheConf();

my $platform = getPlatform();

my $maxClients;
my $maxSpareServers;
my $minSpareServers;

if ($platform eq 'windows')
{
    $maxClients = peek($$hash{'ThreadsPerChild'});
}
else # unix
{
    $maxClients = peek($$hash{'MaxClients'});
    $maxSpareServers = peek($$hash{'MaxSpareServers'});
    $minSpareServers = peek($$hash{'MinSpareServers'});
}

printResult(
    $maxClients,                             'number',
    peek($$hash{'MaxRequestsPerChild'}),     'number',
    $maxSpareServers,                        'number',
    $minSpareServers,                        'number',
    peek($$hash{'StartServers'}),            'number',
    peek($$hash{'TimeOut'}),                 'number',
    peek($$hash{'ListenBackLog'}),           'number',
    peek($$hash{'KeepAlive'}),               'string',
    peek($$hash{'MaxKeepAliveRequests'}),    'number',
    peek($$hash{'KeepAliveTimeout'}),        'number',
    peek($$hash{'SSLSessionCacheTimeout'}),  'number',
    peek($$hash{'HostnameLookups'}),         'string',
    peek($$hash{'LogLevel'}),                'string',
    peek($$hash{'Oc4jSelectMethod'}),        'string',
    peek($$hash{'Oc4jCacheSize'}),           'number',
);
