#!/usr/local/bin/perl
# 
# $Header: emll/sysman/admin/scripts/ias/Apache_getVirtualHosts.pl /main/3 2010/06/22 23:09:59 aghanti Exp $
#
# Apache_getVirtualHosts.pl
# 
# Copyright (c) 2004, 2010, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      Apache_getVirtualHosts.pl - Apache ECM integration: get virtual hosts
#
#    DESCRIPTION
#      Command-line utility called by the Agent to retrieve Apache configuration
#      information for virtual hosts. For each virtual host directive in httpd.conf,
#      outputs the ip and port for the virtual host, and the server name and type
#      for the associated host.
#
#      Implements the VirtualHosts metric defined in oracle_apache.xml.
#
#      Command-line arguments: <oracle home> <ohs instance id (AS11 onwards)>
#
#    NOTES
#
#    MODIFIED   (MM/DD/YY)
#    aghanti     06/17/10 - Consider OHS instance id for AS11
#    jsmoler     06/09/09 - grab fixes from 10.2.0.5 GC
#    jsmoler     07/14/06 - use parseApacheConf (bug 5224028)
#    jsutton     02/12/09 - virtual host port may be an arbitrary string
#    jsmoler     05/19/05 - dynamically determine root conf file 
#    jsmoler     03/03/05 - use vhost utility
#    jsmoler     01/28/05 - apache -> Apache
#    jsmoler     12/15/04 - change space to empty string 
#    jsmoler     10/05/04 - 
#    jsmoler     10/04/04 - jsmoler_ecm01
#    jsmoler     08/19/04 - Creation
# 

use strict;
use ias::Apache_confFileParser;
use ias::asecm;

my $oracleHome = $ARGV[0];
setOracleHome($oracleHome);

my $ohsId = "";
if (-e "$oracleHome/config/OPMN/opmn/opmn.xml")
{
  # AS11: OHS instance ID has been passed as an argument
  $ohsId = $ARGV[1];
  # Set ohsId in the ENV. It will be used by asecm::parseApacheConf() later
  $ENV{'CCR_OHS_ID'} = $ohsId;
}

my $hash = parseApacheConf();
my @vhosts = getApacheVHosts($hash);

for my $vhost (@vhosts)
{
    my $addr = $$vhost{'address'};
    my $ip = $$vhost{'ip'};
    my $port = $$vhost{'port'};
    my $serverName;
    my $serverType;
    my $props = $$vhost{'properties'};
    if ($props)
    {
        $serverName = peek($$props{'ServerName'});
        
        if ($ip eq '_default_')
        {
            # _default_ isn't really an IP, so clear the IP
            $ip = '';
            $serverType = 'default';
        }
        else
        {
            my $nameVHost = $$hash{'NameVirtualHost'};
            if ($nameVHost && contains($addr, @{$nameVHost}))
            {
                $serverType = 'name';
            }
            else
            {
                $serverType = 'ip';
            }
        }
    }
    
    printResult(
        $ip,            'string',
        $port,          'string',
        $serverName,    'string',
        $serverType,    'string',
    );
}
