#!/usr/local/bin/perl
# 
# $Header: emll/sysman/admin/scripts/ias/Apache_listConfigFiles.pl /main/2 2010/06/22 23:09:59 aghanti Exp $
#
# Apache_listConfigFiles.pl
# 
# Copyright (c) 2004, 2010, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      Apache_listConfigFiles.pl - Apache ECM integration: list configuration files
#
#    DESCRIPTION
#      Command line utility called by the Agent to retrieve a list of configuration
#      files for Apache. Outputs the full path, size, and modification time of each
#      file (see statFiles in asecm.pm).
#
#      Implements the ConfigFileList metric defined in oracle_apache.xml.
#
#      Command-line arguments: <oracle home> <for upload flag> <target name> <ohs instance id (AS11 onwards)>
#
#    NOTES
#
#    MODIFIED   (MM/DD/YY)
#    aghanti     06/17/10 - Consider OHS instance id for AS11
#    jsmoler     06/09/09 - grab fixes from 10.2.0.5 GC
#    jsmoler     04/17/08 - filter duplicate include files
#    jsmoler     07/14/06 - use parseApacheConf (bug 5224028)
#    jsmoler     08/03/05 - collapse statFiles and restatFiles 
#    jsmoler     05/19/05 - dynamically determine root conf file 
#    jsmoler     01/10/05 - one more apache -> Apache 
#    jsmoler     12/16/04 - change paths to Apache 
#    jsmoler     10/25/04 - list all included .conf files 
#    jsmoler     10/04/04 - jsmoler_ecm01
#    jsmoler     08/18/04 - Creation
# 

use strict;
use ias::asecm;
use ias::Apache_confFileParser;

my $oracleHome = $ARGV[0];
setOracleHome($oracleHome);
my $forUploadStr = $ARGV[1];
my $forUpload = $forUploadStr eq 'true';
my $targetName = $ARGV[2];

my $opmnXml = 'opmn/conf/opmn.xml';
my $jservProp = 'Apache/Jserv/etc/jserv.properties';
my $mimeTypes = 'Apache/Apache/conf/mime.types';

my $ohsId = "";
if (-e "$oracleHome/config/OPMN/opmn/opmn.xml")
{
  # AS11: OHS instance ID has been passed as an argument
  $ohsId = $ARGV[3];
  # Set ohsId in the ENV. It will be used by asecm::parseApacheConf() later
  $ENV{'CCR_OHS_ID'} = $ohsId;
  $opmnXml = 'config/OPMN/opmn/opmn.xml';
  $mimeTypes = "config/OHS/$ohsId/mime.types";
}

statFiles(
    $forUpload,
    $targetName,
    $opmnXml,
    $jservProp,
    $mimeTypes
);

my @confFiles;
parseApacheConf(\@confFiles);
my %seen;
for my $confFile (@confFiles)
{
    if (!defined($seen{$confFile}))
    {
        statFile($confFile, $forUpload, $targetName);
    }
    $seen{$confFile} = 1;
}
