#!/usr/local/bin/perl
# 
# $Header: emll/sysman/admin/scripts/ias/IAS_getConsoleInfo.pl /main/6 2012/10/03 15:57:41 fmorshed Exp $
#
# IAS_getConsoleInfo.pl
# 
# Copyright (c) 2004, 2012, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      IAS_getConsoleInfo.pl - IAS ECM integration: get console configuration information
#
#    DESCRIPTION
#      Command-line utility called by the Agent to retrieve console configuration
#      information for IAS. Includes the agent and console URLs.
#
#      Implements the ConsoleInfo metric defined in oracle_ias.xml.
#
#      Command-line arguments: <oracle home> <host name>
#
#    NOTES
#
#    MODIFIED   (MM/DD/YY)
#    fmorshed    10/02/12 - Remove / as first character to query targets.xml
#    fmorshed    01/19/12 - In advent of central collector, change query of
#                targets.xml to account for the new hierarchy of tags.
#    jsutton     07/26/07 - Pick up existing shared OH work
#    jsutton     07/25/07 - Shared home work
#    pparida     09/25/06 - Fix bug 5561234: For iAS 10.1.3, get console info
#                           from targets.xml
#    pparida     07/18/06 - Sync with 10.2.0.2 EMGC 
#    jsmoler     12/23/05 - handle case of no emd.properties file for 10.1.3 
#    ndutko      08/03/05 - ndutko_code_checkin
#    jsmoler     12/10/04 - no error if xml file not found 
#    jsmoler     12/03/04 - change url to path 
#    jsmoler     12/02/04 - fail if xml file not found 
#    jsmoler     10/04/04 - jsmoler_ecm01
#    jsmoler     09/13/04 - Creation
# 

use strict;
use ias::asecm;
use ias::propertiesFileParser;
use ias::simpleXPath;

my $oracleHome = $ARGV[0];
setOracleHome($oracleHome);
my $hostName = $ARGV[1];

my $emdProtocol;
my $emdHost;
my $emdPort;
my $emdPath;
my $emdPropsFile = "$oracleHome/sysman/config/emd.properties";
if (-e $emdPropsFile)
{
    my %hash = parsePropertiesFile($emdPropsFile);
    my $emdURL = $hash{'EMD_URL'};
    if ($emdURL =~ /^([^:]*):\/\/([^:\/]*):([0-9]*)\/(.*)/)
    {
        $emdProtocol = $1;
        $emdHost = $2;
        $emdPort = $3;
        $emdPath = $4;
    }
}

my $webSite;
my $consoleProtocol;
my $consoleHost;
my $consolePort;
my $xmlFile = "$oracleHome/sysman/j2ee/config/emd-web-site.xml";
if (-e $xmlFile)
{
    my $webSite = (simpleXPathQuery($xmlFile, 'web-site'))[0];
    if (defined($$webSite{'protocol'}))
    {
        $consoleProtocol = $$webSite{'protocol'};
    }
    else
    {
        $consoleProtocol = 'http';
    }
    $consoleHost = $hostName;
    $consolePort = $$webSite{'port'};
}
else
{
  # If emd-web-site.xml is not present (as is the case for iAS 10.1.3), we extract
  # the console info from the discovered targets.xml
  if(defined($ENV{CCR_CONFIG_HOME}))
  {
   my $discoveredTargetsFile = "$ENV{CCR_CONFIG_HOME}/config/default/targets.xml";
   if (-e $discoveredTargetsFile)
   {
     my $ohQueryPrefix = 'TargetHomes/TargetHome[@LOCATION="' . $ENV{ORACLE_HOME} . '"]';
     my $consoleProp = (simpleXPathQuery($discoveredTargetsFile, $ohQueryPrefix . '/Targets/Target[@TYPE="oracle_ias"]/Property[@NAME="StandaloneConsoleURL"]'))[0];
     if(defined($$consoleProp{'VALUE'}))
     {
       my $consoleURL = $$consoleProp{'VALUE'};
       ($consoleProtocol, my $consoleHostPortPath) = split(/:\/\//, $consoleURL);
       ($consoleHost, my $consolePortPath) = split(/:/, $consoleHostPortPath);
       ($consolePort, undef) = split(/\//, $consolePortPath);
     }
   }
  }
}

printResult(
    $emdProtocol,       'string',
    $emdHost,           'string',
    $emdPort,           'number',
    $emdPath,           'string',
    $consoleProtocol,   'string',
    $consoleHost,       'string',
    $consolePort,       'number',
);
