#!/usr/local/bin/perl
# 
# $Header: IAS_getDCMInfo.pl 03-aug-2005.08:54:58 ndutko Exp $
#
# IAS_getDCMInfo.pl
# 
# Copyright (c) 2004, 2005, Oracle. All rights reserved.  
#
#    NAME
#      IAS_getDCMInfo.pl - IAS ECM integration: get DCM-related configuration information
#
#    DESCRIPTION
#      Command-line utility called by the Agent to retrieve DCM-related configuration
#      information for IAS. Includes the repository type.
#
#      Implements the DCMInfo metric defined in oracle_ias.xml.
#
#      Command-line arguments: <oracle home>
#
#    NOTES
#
#    MODIFIED   (MM/DD/YY)
#    ndutko      08/03/05 - ndutko_code_checkin
#    jsmoler     01/31/05 - check InfrastructureUse
#    jsmoler     10/04/04 - jsmoler_ecm01
#    jsmoler     09/13/04 - Creation
# 

use strict;
use ias::asecm;
use ias::propertiesFileParser;

my $oracleHome = $ARGV[0];
setOracleHome($oracleHome);
my %iasHash = ();
if (-e "$oracleHome/config/ias.properties")
{
  %iasHash = parsePropertiesFile("$oracleHome/config/ias.properties");

  my $reposType = 'file';
  if ($iasHash{'InfrastructureUse'} ne 'false')
  {
    my %hash = parsePropertiesFile("$oracleHome/dcm/config/dcm.conf");
    $reposType = $hash{'repository_type'};
  }

  printResult(
      $reposType, 'string',
  );
}
