#!/usr/local/bin/perl
# 
# $Header: getDeployedApps.pl 27-dec-2005.11:35:42 jsmoler Exp $
#
# IAS_getDeployedApps.pl
# 
# Copyright (c) 2004, 2005, Oracle. All rights reserved.  
#
#    NAME
#      IAS_getDeployedApps.pl - IAS ECM integration: get deployed applications
#
#    DESCRIPTION
#      Command-line utility called by the Agent to retrieve a list of deployed
#      applications for an IAS instance.
#
#      Implements the DeployedApps metric defined in oracle_ias.xml.
#
#      Command-line arguments: <oracle home> <version category>
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    jsmoler     12/27/05 - support 10.1.3 system app 
#    jsmoler     10/29/04 - jsmoler_ecm_041021a
#    jsmoler     10/20/04 - Creation
# 

use strict;
use ias::asecm;

my $oracleHome = $ARGV[0];
setOracleHome($oracleHome);
my $versionCategory = $ARGV[1];

my @instances = listOC4JInstances();
for my $instanceName (@instances)
{
    my @apps = listOC4JDeployedApps($instanceName, $versionCategory);
    for my $appName (@apps)
    {
        printResult(
            $instanceName, 'string',
            $appName,      'string',
        );
    }
}
