#!/usr/local/bin/perl
# 
# $Header: emll/sysman/admin/scripts/ias/IAS_getGeneral.pl /main/4 2010/08/17 03:19:37 asunar Exp $
#
# IAS_getGeneral.pl
# 
# Copyright (c) 2004, 2010, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      IAS_getGeneral.pl - IAS ECM integration: get general configuration information
#
#    DESCRIPTION
#      Command-line utility called by the Agent to retrieve general configuration
#      information for IAS.
#
#      Implements the General metric defined in oracle_ias.xml.
#
#      Command-line arguments: <oracle home>
#
#    NOTES
#
#    MODIFIED   (MM/DD/YY)
#    asunar      08/10/10 - IAS_getGeneral.pl should return the latest version
#                           of IAS
#    aghanti     04/15/10 - XbranchMerge aghanti_bug-9557735 from
#                           st_emll_10.3.3
#    aghanti     04/14/10 - Try to get iAS version for AS11g from OUI inventory
#    pparida     07/18/06 - Sync with 10.2.0.2 EMGC 
#    ndutko      08/03/05 - ndutko_code_checkin
#    jsmoler     01/31/05 - check InfrastructureUse
#    jsmoler     10/04/04 - jsmoler_ecm01
#    jsmoler     09/13/04 - Creation
# 

use strict;
use ias::asecm;
use ias::propertiesFileParser;
use LL_OH_Utilities;

my $oracleHome = $ARGV[0];
setOracleHome($oracleHome);
my $installType = $ARGV[1];
my $version = $ARGV[2];

my %hash = ();
my $dbName;
if (-e "$oracleHome/config/ias.properties")
{
  %hash = parsePropertiesFile("$oracleHome/config/ias.properties");
  if ($hash{'InfrastructureUse'} ne 'false')
  {
      $dbName = $hash{'InfrastructureDBCommonName'};
  }
}
else
{
  # this is AS11g; get iAS version from inventory
  my $tmpInfo = LLParseInventory::getInfo($ENV{USER_ORACLE_HOME},"TOPLEVEL");
  $tmpInfo =~ /^\s*([^\s]*)\s+([^\s]*)/;
  my $comp=$1;
  # $comp is empty means there is no comps.xml in which case the default version
  # should be returned
  if($comp eq "")
  {
    $version =  "1.0.2.2";
  }
  else
  {
     $version = LL_OH_Utilities::getCompVersion($ENV{USER_ORACLE_HOME},$comp);
     if($version eq "")
     {
       EMD_PERL_WARN("IAS_getGeneral.pl returned the empty version for the metric General");
     }
  }
}

printResult(
    $installType,  'string',
    $dbName,       'string',
    $version,      'string',
);
