#!/usr/local/bin/perl
# 
# $Header: emll/sysman/admin/scripts/ias/IAS_getOPMNInfo.pl /main/2 2010/04/15 07:04:17 aghanti Exp $
#
# IAS_getOPMNInfo.pl
# 
# Copyright (c) 2004, 2010, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      IAS_getOPMNInfo.pl - IAS ECM integration: get OPMN-related configuration information
#
#    DESCRIPTION
#      Command-line utility called by the Agent to retrieve OPMN-related configuration
#      information for IAS.
#
#      Implements the OPMNInfo metric defined in oracle_ias.xml.
#
#      Command-line arguments: <oracle home>
#
#    NOTES
#
#    MODIFIED   (MM/DD/YY)
#    aghanti     04/15/10 - XbranchMerge aghanti_bug-9557735 from
#                           st_emll_10.3.3
#    aghanti     04/14/10 - For AS11g, look for opmn.xml in a different
#                           location
#    ndutko      08/03/05 - ndutko_code_checkin
#    jsmoler     10/04/04 - jsmoler_ecm01
#    jsmoler     09/13/04 - Creation
# 

use strict;
use ias::asecm;
use ias::simpleXPath;

my $oracleHome = $ARGV[0];
setOracleHome($oracleHome);
my $xmlFile = "$oracleHome/opmn/conf/opmn.xml";

# Look for opmn.xml in a different location for 11g
if (!-e $xmlFile) {
  $xmlFile = "$oracleHome/config/OPMN/opmn/opmn.xml";
}

if (-e $xmlFile)
{
  my $port = (simpleXPathQuery($xmlFile, 'opmn/notification-server/port'))[0];
  my $ssl = (simpleXPathQuery($xmlFile, 'opmn/notification-server/ssl'))[0];
  my $nsLog = (simpleXPathQuery($xmlFile, 'opmn/notification-server/log-file'))[0];
  my $pmLog = (simpleXPathQuery($xmlFile, 'opmn/process-manager/log-file'))[0];

  printResult(
      $$port{'request'},          'number',
      $$port{'remote'},           'number',
      $$port{'local'},            'number',
      $$ssl{'enabled'} eq 'true', 'number',
      $$nsLog{'level'},           'number',
      $$pmLog{'level'},           'number',
  );
}
