#!/usr/local/bin/perl
# 
# $Header: IAS_getTargets.pl 16-dec-2004.15:22:13 jsmoler Exp $
#
# IAS_getTargets.pl
# 
# Copyright (c) 2004, Oracle. All rights reserved.  
#
#    NAME
#      IAS_getTargets.pl - IAS ECM integration: get targets
#
#    DESCRIPTION
#      Command-line utility called by the Agent to retrieve a list of targets
#      for an IAS instance.
#
#      Implements the Targets metric defined in oracle_ias.xml.
#
#      Command-line arguments: <oracle home>
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    jsmoler     12/16/04 - make list inclusive 
#    jsmoler     10/29/04 - jsmoler_ecm_041021a
#    jsmoler     10/22/04 - filter on target type 
#    jsmoler     10/20/04 - Creation
# 

use strict;
use ias::asecm;

my $oracleHome = $ARGV[0];
setOracleHome($oracleHome);

my @excludeTargetTypes = (
    'oracle_ias',
    'oracle_bc4j',
    'oracle_emd',
    'host',
    'oracle_database',
    'oracle_listener',
    'oracle_emrep',
    'website',
);

my @results = split(/\n/, `$oracleHome/bin/emctl config agent listtargets`);
for my $line (@results)
{
    if ($line =~ /^\[([^,]+), ([^,]+)\]$/)
    {
        my $targetName = $1;
        my $targetType = $2;
        if (!contains($targetType, @excludeTargetTypes))
        {
            printResult(
                $targetName,    'string',
                $targetType,    'string',
            );
        }
    }
}
