#!/usr/local/bin/perl
# 
# $Header: emll/sysman/admin/scripts/ias/IAS_listConfigFiles.pl /main/2 2010/04/15 07:04:17 aghanti Exp $
#
# IAS_listConfigFiles.pl
# 
# Copyright (c) 2004, 2010, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      IAS_listConfigFiles.pl - IAS ECM integration: list configuration files
#
#    DESCRIPTION
#      Command line utility called by the Agent to retrieve a list of configuration
#      files for IAS. Outputs the full path, size, and modification time of each
#      file (see statFiles in asecm.pm).
#
#      Implements the ConfigFileList metric defined in oracle_ias.xml.
#
#      Command-line arguments: <oracle home> <for upload flag> <target name>
#
#    NOTES
#
#    MODIFIED   (MM/DD/YY)
#    aghanti     04/15/10 - XbranchMerge aghanti_bug-9557735 from
#                           st_emll_10.3.3
#    aghanti     04/14/10 - Add files for AS11g
#    jsmoler     08/21/08 - add more files for 6656253
#    jsmoler     08/03/05 - collapse statFiles and restatFiles 
#    jsmoler     10/04/04 - jsmoler_ecm01
#    jsmoler     09/13/04 - Creation
# 

use strict;
use ias::asecm;

my $oracleHome = $ARGV[0];
setOracleHome($oracleHome);
my $forUploadStr = $ARGV[1];
my $forUpload = $forUploadStr eq 'true';
my $targetName = $ARGV[2];

# List files from the following directories under the Oracle Home
statAllFiles('config', 'xml', 'properties');
statAllFiles('sysman/config', 'properties');
statAllFiles('sysman/j2ee/config', 'xml');
statAllFiles('opmn/conf', 'xml', 'conf');
statAllFiles('dcm/config', 'xml', 'conf');
statAllFiles('sysman/admin/default_collection', 'xml');
statAllFiles('config/OPMN/opmn', 'xml');

# List additional specific files
statFiles(
    $forUpload,
    $targetName,
    
    'network/admin/sqlnet.ora',
    'network/admin/tnsnames.ora',
    'sysman/javacache/admin/javacache.xml',
    'diagnostics/config/logloader.xml',
    'diagnostics/config/logloaderd.properties',
);

#
# Prints information about all files in a directory that match a set of extensions.
#
# Arguments
#   0: Name of a directory under the Oracle Home
#  ..: List of extensions
#
sub statAllFiles
{
    my $dirName = shift(@_);
    my @extensions = @_;

    if ( -e "$oracleHome/$dirName" )
    {
        my $dir;
        opendir($dir, "$oracleHome/$dirName");
        for my $file (readdir($dir))
        {
            if ($file =~ /.+\.([^.]+)$/)
            {
                my $extension = $1;
                if (contains($extension, @extensions))
                {
                    statFile("$oracleHome/$dirName/$file", $forUpload, $targetName);
                }
            }
        }
        closedir($dir);
    }
}
