#!/usr/local/bin/perl
# 
# $Header: emll/sysman/admin/scripts/ias/Jserv_getZones.pl /main/3 2010/10/07 08:33:20 asunar Exp $
#
# Jserv_getZones.pl
# 
# Copyright (c) 2005, 2010, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      Jserv_getZones.pl - <one-line expansion of the name>
#
#    DESCRIPTION
#      <short description of component this file declares/defines>
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    asunar      10/04/10 - bug 9859640:Setting CCR_OHS_ID in the environment
#    jsmoler     06/03/09 - use parseApacheConf (bug 5224028)
#    jsutton     09/27/05 - jsutton_jserv_cfg_mtrx
#    jsutton     09/23/05 - Creation
# 

use strict;
use ias::asecm;
use ias::Apache_confFileParser;

# global variable to keep track of the zones that have already been processed
my %addedZones = ();

my $oracleHome = $ARGV[0];
setOracleHome($oracleHome);

my @confFiles;
my $ohsId = "";

if (-e "$oracleHome/config/OPMN/opmn/opmn.xml")
{
  # AS11: OHS instance ID has been passed as an argument
  $ohsId = $ARGV[1];
  # Set ohsId in the ENV. It will be used by asecm::parseApacheConf() later
  $ENV{'CCR_OHS_ID'} = $ohsId;
}
my $hash = parseApacheConf(\@confFiles);

my ($propFile,$confFile, @JservCfgFiles);
for $confFile (@confFiles)
{
  if (-e $confFile)
  {
    open (CFILE, $confFile);
    my @cLines = <CFILE>;
    close CFILE;
    foreach (@cLines)
    {
      if (/^\s*ApJServProperties\s+/)
      {
        s/^\s*ApJServProperties\s+//;
        chomp;
        push (@JservCfgFiles, $_);
      }
      if (/^\s*ApJServGroup\s+/)
      {
        (undef,undef,undef,undef,$propFile) = split;
        push (@JservCfgFiles, $propFile);
      }
    }
  }
}
foreach $confFile (@JservCfgFiles)
{
  if (-e $confFile)
  {
    open (CFILE, $confFile);
    my @cLines = <CFILE>;
    close CFILE;
    foreach (@cLines)
    {
      if (/^\s*zones=/)
      {
        s/^\s*zones=//;
        chomp;
        if (!defined $addedZones{$_})
        {
          print "em_result=".$_."\n";
          $addedZones{$_} = 1;
        }
      }
    }
  }
}
