#!/usr/local/bin/perl
# 
# $Header: emll/sysman/admin/scripts/ias/Jserv_listConfigFiles.pl /main/4 2010/10/07 08:33:20 asunar Exp $
#
# Jserv_listConfigFiles.pl
# 
# Copyright (c) 2005, 2010, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      Jserv_listConfigFiles.pl - <one-line expansion of the name>
#
#    DESCRIPTION
#      <short description of component this file declares/defines>
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    asunar      10/04/10 - bug 9859640:Setting CCR_OHS_ID in the environment
#    jsmoler     06/03/09 - use parseApacheConf (bug 5224028)
#    jsutton     02/12/09 - Check for duplicate files
#    jsutton     09/27/05 - jsutton_jserv_cfg_mtrx
#    jsutton     09/23/05 - Creation
# 

use strict;
use ias::asecm;
use ias::Apache_confFileParser;

my $oracleHome = $ARGV[0];
setOracleHome($oracleHome);
my $forUploadStr = $ARGV[1];
my $forUpload = defined($forUploadStr) && $forUploadStr eq 'true';
my $targetName = $ARGV[2];

my @confFiles;
my $ohsId = "";
if (-e "$oracleHome/config/OPMN/opmn/opmn.xml")
{
  # AS11: OHS instance ID has been passed as an argument
  $ohsId = $ARGV[1];
  # Set ohsId in the ENV. It will be used by asecm::parseApacheConf() later
  $ENV{'CCR_OHS_ID'} = $ohsId;
}
my $hash = parseApacheConf(\@confFiles);

my %seen = ();

my ($propFile,$confFile);
for $confFile (@confFiles)
{
  if (-e $confFile)
  {
    open (CFILE, $confFile);
    my @cLines = <CFILE>;
    close CFILE;
    foreach (@cLines)
    {
      if (/^\s*ApJServProperties\s+/)
      {
        s/^\s*ApJServProperties\s+//;
        chomp;
        statFile($_, $forUpload, $targetName);
        $seen{$_} = $_;
      }
      if (/^\s*ApJServGroup\s+/)
      {
        (undef,undef,undef,undef,$propFile) = split;
        # only print out info if this file was not yet processed
        if (!defined($seen{$propFile}))
        {
          statFile($propFile, $forUpload, $targetName);
          $seen{$propFile} = ${propFile};
        }
      }
    }
  }
}
