#!/usr/local/bin/perl
# 
# $Header: getDataSources.pl 16-jan-2006.08:53:59 jsmoler Exp $
#
# OC4J_getDataSources.pl
# 
# Copyright (c) 2004, 2006, Oracle. All rights reserved.  
#
#    NAME
#      OC4J_getDataSources.pl - OC4J ECM integration: get data sources
#
#    DESCRIPTION
#      Command-line utility called by the Agent to retrieve a list of data
#      sources for an OC4J instances, and configuration information about each
#      data source.
#
#      Implements the DataSources metric defined in oc4j.xml.
#
#      Command-line arguments: <oracle home> <instance name> <default app only>
#
#    NOTES
#
#    MODIFIED   (MM/DD/YY)
#    jsmoler     01/16/06 - add flag to only collect data sources of default 
#                           app, for backward compatibility 
#    jsmoler     12/09/05 - Backport jsmoler_bug-4769271 from main 
#    jsmoler     11/29/05 - dynamically determine path of XML file,
#                           get data sources for all applications
#                           (bug 4769271) 
#    jsmoler     12/07/05 - Backport jsmoler_bug-4765772 from main 
#    jsmoler     11/28/05 - fix inactivity-timeout typo (bug 4765772) 
#    jsmoler     11/12/04 - add JDBC URL
#    jsmoler     10/04/04 - jsmoler_ecm01
#    jsmoler     08/26/04 - Creation
# 

use strict;
use ias::simpleXPath;
use ias::asecm;

my $oracleHome = $ARGV[0];
setOracleHome($oracleHome);
my $instanceName = $ARGV[1];

my $defaultAppOnly = defined($ARGV[2]) && $ARGV[2] eq 'default-app-only';

my @dataSourceFiles = listOC4JDataSourceFiles($instanceName);
for my $appInfo (@dataSourceFiles)
{
    if ($defaultAppOnly && $$appInfo{'application'} ne 'default')
    {
        next;
    }
    my @dataSources = simpleXPathQuery(
        $$appInfo{'file'},
        'data-sources/data-source'
    );
    my %jndiLocHash;
    for my $dataSource (@dataSources)
    {
        $jndiLocHash{$$dataSource{'location'}} = $dataSource;
    }
    for my $jndiLoc (keys %jndiLocHash)
    {
        my $dataSource = $jndiLocHash{$jndiLoc};
        if ($defaultAppOnly)
        {
            printResult(
                $$dataSource{'name'},               'string',
                # no application column
                $$dataSource{'location'},           'string',
                $$dataSource{'class'},              'string',
                $$dataSource{'connection-driver'},  'string',
                $$dataSource{'url'},                'string',
                $$dataSource{'max-connections'},    'number',
                $$dataSource{'min-connections'},    'number',
                $$dataSource{'wait-timeout'},       'number',
                $$dataSource{'inactivity-timeout'}, 'number',
            );
        }
        else
        {
            printResult(
                $$dataSource{'name'},               'string',
                $$appInfo{'application'},           'string',
                $$dataSource{'location'},           'string',
                $$dataSource{'class'},              'string',
                $$dataSource{'connection-driver'},  'string',
                $$dataSource{'url'},                'string',
                $$dataSource{'max-connections'},    'number',
                $$dataSource{'min-connections'},    'number',
                $$dataSource{'wait-timeout'},       'number',
                $$dataSource{'inactivity-timeout'}, 'number',
            );
        }
    }
}
