#!/usr/local/bin/perl
# 
# $Header: OC4J_getPortRanges.pl 18-jul-2006.13:17:02 pparida Exp $
#
# OC4J_getPortRanges.pl
# 
# Copyright (c) 2004, 2006, Oracle. All rights reserved.  
#
#    NAME
#      OC4J_getPortRanges.pl - OC4J ECM integration: get port ranges
#
#    DESCRIPTION
#      Command-line utility called by the Agent to retrieve port ranges
#      configured for an OC4J instance.
#
#      Implements the PortRanges metric defined in oc4j.xml.
#
#      Command-line arguments: <oracle home> <instance name>
#
#    NOTES
#
#    MODIFIED   (MM/DD/YY)
#    pparida     07/18/06 - Sync with 10.2.0.2 EMGC 
#    jsmoler     11/23/05 - support 10.1.3 
#    jsutton     03/08/06 - Handle pre-904 opmn.xml format 
#    jsutton     02/14/06 - generalize xpath query for OC4J ports
#    jsmoler     10/04/04 - jsmoler_ecm01
#    jsmoler     08/26/04 - Creation
# 
use strict;
use ias::simpleXPath;
use ias::asecm;
use ias::propertiesFileParser;

my $oracleHome = $ARGV[0];
setOracleHome($oracleHome);
my $instanceName = $ARGV[1];
my @results;
my %hash = ();
if (-e "$oracleHome/config/ias.properties")
{
  %hash = parsePropertiesFile("$oracleHome/config/ias.properties");
}
if (defined($hash{'Version'}))
{
  # check for < 9.0.4, xpath query is DIFFERENT for opmn.xml OC4J ports
  my @verParts = split(/\./, $hash{'Version'});
  if (@verParts >= 3)
  {
    if ($verParts[0] >= 9)
    {
      if ($verParts[1] == 0 && $verParts[2] < 4)
      {
        @results = (simpleXPathQuery("$oracleHome/opmn/conf/opmn.xml",
                                     'ias-instance/process-manager/oc4j[@instanceName="' . $instanceName .'"]/port'))[0];
        if (@results == 1)
        {
          my $portInfo = $results[0];
          if (defined($$portInfo{'ajp'}))
          {
            print "em_result=ajp|$$portInfo{'ajp'}\n";
          }
          if (defined($$portInfo{'rmi'}))
          {
            print "em_result=rmi|$$portInfo{'rmi'}\n";
          }
          if (defined($$portInfo{'jms'}))
          {
            print "em_result=jms|$$portInfo{'jms'}\n";
          }
        }
      }
      else
      {
        # pull the ports from this instance's info in opmn.xml (iAS 9.0.4+)
        @results = simpleXPathQuery("$oracleHome/opmn/conf/opmn.xml",
                                    'opmn//process-type[@module-id="OC4J"][@id="' . $instanceName . '"]/port');
        my %protocolHash;
        for my $result (@results)
        {
          my $protocol = $$result{'protocol'};
          if (defined($protocol))
          {
            my $current = $protocolHash{$protocol};
            if (defined($current))
            {
              $current = $current . ',' . $$result{'range'}
            }
            else
            {
              $current = $$result{'range'};
            }
            $protocolHash{$protocol} = $current;
          }
          else
          {
            $protocolHash{$$result{'id'}} = $$result{'range'};
          }
        }
        for my $protocol (keys %protocolHash)
        {
          printResult(
              $protocol,                  'string',
              $protocolHash{$protocol},   'string'
          );
        }
      }
    }
  }
}
