#!/usr/local/bin/perl
# 
# $Header: emll/sysman/admin/scripts/ias/OC4J_getResourceConfig.pl /main/2 2009/09/10 14:00:01 jsmoler Exp $
#
# OC4J_getResourceUsage.pl
# 
# Copyright (c) 2004, 2009, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      OC4J_getResourceConfig.pl - OC4J ECM integration: get resource configuration
#
#    DESCRIPTION
#      Command-line utility called by the Agent to retrieve resource-usage
#      related configuration information for an OC4J instance.
#
#      Implements the ResourceConfig metric defined in oc4j.xml.
#
#      Command-line arguments: <oracle home> <instance name>
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    jsmoler     09/10/09 - check if opmn.xml exists
#    jsmoler     06/09/09 - grab fixes from 10.2.0.5 GC
#    jsmoler     07/12/07 - support OPMN variables
#    jsmoler     10/29/04 - jsmoler_ecm_041021a
#    jsmoler     10/05/04 - fix command-line option parsing, add numprocs
#    jsmoler     10/04/04 - jsmoler_ecm01
#    jsmoler     09/10/04 - Creation
# 

use strict;
use ias::asecm;
use ias::simpleXPath;

my $oracleHome = $ARGV[0];
setOracleHome($oracleHome);
my $instanceName = $ARGV[1];

if (! -e "$oracleHome/opmn/conf/opmn.xml")
{
    exit;
}

my %moduleData = ias::asecm::getOpmnModuleData({
    'process-type' => $instanceName,
    'module' => 'OC4J'
});

my $javaOptions = $moduleData{'start-parameters'}{'java-options'};

my $max;
my $start;

if (defined($javaOptions))
{
    my @params = parseCommandLine($javaOptions);
    for (my $i = 0; $i < @params; $i += 2)
    {
        my $opt = $params[$i];
        my $val = $params[$i + 1];
        if ($opt =~ /^X?ms(.*)/)
        {
            $start = parseSize($1);
        }
        elsif ($opt =~ /^X?mx(.*)/)
        {
            $max = parseSize($1);
        }
    }
}

my @result2 = simpleXPathQuery("$oracleHome/opmn/conf/opmn.xml",
                               'opmn//process-type[@module-id="OC4J"][@id="' . $instanceName . '"]/process-set');

my $totalProcs = 0;
for my $resultRef (@result2)
{
    my $numProcs = $$resultRef{'numprocs'};
    $totalProcs += $numProcs;
}

printResult(
    $start,         'number',
    $max,           'number',
    $totalProcs,    'number',
);

sub parseSize
{
    my $str = $_[0];

    if ($str =~ /^(.*)[mM]$/)
    {
        return $1;
    }
    if ($str =~ /^(.*)[kK]$/)
    {
        return $1 / 1024;
    }
    return $str / (1024 * 1024);
}
