#!/usr/local/bin/perl
# 
# $Header: emll/sysman/admin/scripts/ias/OC4J_getWebModuleMappings.pl /main/1 2009/06/09 13:51:41 jsmoler Exp $
#
# OC4J_getWebModuleMappings.pl
# 
# Copyright (c) 2004, 2009, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      OC4J_getWebModuleMappings.pl - OC4J ECM integration: get web module mappings
#
#    DESCRIPTION
#      Command-line utility called by the Agent to retrieve a list of web module
#      mappings for an OC4J instance. Includes the name and root URL of each
#      web module.
#
#      Implements the WebModuleMappings metric defined in oc4j.xml.
#
#      Command-line arguments: <oracle home> <instance name> <version category>
#
#    NOTES
#
#    MODIFIED   (MM/DD/YY)
#    jsmoler     06/09/09 - grab fixes from 10.2.0.5 GC
#    jsmoler     03/06/06 - use simpleXPath module 
#    jsmoler     12/23/05 - support system app for 10.1.3 
#    echolank    12/08/05 - strip out common web module processing 
#    jsmoler     08/22/05 - filter out extra apps
#    jsmoler     10/20/04 - boolean as integer 
#    jsmoler     10/04/04 - jsmoler_ecm01
#    jsmoler     08/26/04 - Creation
# 

use strict;
use ias::asecm;
use ias::simpleXPath;

my $oracleHome = $ARGV[0];
setOracleHome($oracleHome);
my $instanceName = $ARGV[1];
my $versionCategory = $ARGV[2];

my @webModuleMappings = listOC4JWebModuleMappings($instanceName, $versionCategory);

for my $resultRef (@webModuleMappings)
{
    my $loadOnStartup = (ensuredef($$resultRef{'load-on-startup'}) eq 'true') ? 1 : 0;
    printResult(
        $$resultRef{'name'},         'string',
        $$resultRef{'application'},  'string',
        $$resultRef{'root'},         'string',
        $loadOnStartup,              'number',
    );
}
